/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.PreValidationAccountAuth;
import de.businesslogics.ebics.schema.types.DataDigest;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class PreValidationRequest
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private final List<DataDigest> dataDigests = new ArrayList<DataDigest>();
    private final List<PreValidationAccountAuth> accountAuthorisation = new ArrayList<PreValidationAccountAuth>();

    public List<DataDigest> getDataDigests() {
        return this.dataDigests;
    }

    public DataDigest getDataDigest(SignatureVersion version) {
        if (version.equals(SignatureVersion.A006)) {
            version = SignatureVersion.A005;
        }
        for (DataDigest d : this.dataDigests) {
            SignatureVersion sv = d.getSignatureVersion();
            if (sv.equals(SignatureVersion.A006)) {
                sv = SignatureVersion.A005;
            }
            if (!sv.equals(version)) continue;
            return d;
        }
        return null;
    }

    public List<PreValidationAccountAuth> getAccountAuthorisation() {
        return this.accountAuthorisation;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("authenticate", "true");
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("authenticate", "true");
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.printOut("DataDigest", this.dataDigests);
        ps.printOut("AccountAuthorisation", this.accountAuthorisation);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if ("DataDigest".equals(localName) && (!uri.equals(ProtocolVersion.H002.getNamespace()) && parser.allowOrIsChild(0) || parser.allowChild(0))) {
                DataDigest toReturn = new DataDigest();
                this.dataDigests.add(toReturn);
                return toReturn;
            }
            if ("AccountAuthorisation".equals(localName) && parser.allowOrIsChild(-1, 1)) {
                PreValidationAccountAuth toReturn = new PreValidationAccountAuth();
                this.accountAuthorisation.add(toReturn);
                return toReturn;
            }
        }
        return null;
    }
}

