/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.orders.Amount;
import de.businesslogics.ebics.schema.types.AccountNumber;
import de.businesslogics.ebics.schema.types.BankCode;
import de.businesslogics.ebics.schema.types.NationalAccountNumber;
import de.businesslogics.ebics.schema.types.NationalBankcode;
import de.businesslogics.util.Currency;
import org.xml.sax.SAXException;

public class PreValidationAccountAuth
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private static final Currency EUR = Currency.getInstance("EUR");
    SimpleStringElement accountNumber;
    SimpleStringElement accountNumber2;
    SimpleStringElement bankCode;
    SimpleStringElement bankCode2;
    Currency currency = EUR;
    SimpleStringElement accountHolder;
    String description = null;
    Amount amount;

    public PreValidationAccountAuth() {
    }

    public PreValidationAccountAuth(SimpleStringElement accountNumber, SimpleStringElement bankCode) {
        this.accountNumber = accountNumber;
        this.bankCode = bankCode;
    }

    public SimpleStringElement getAccountHolder() {
        return this.accountHolder;
    }

    public void setAccountHolder(SimpleStringElement accountHolder) {
        this.accountHolder = accountHolder;
    }

    public SimpleStringElement getAccountNumber2() {
        return this.accountNumber2;
    }

    public void setAccountNumber2(AccountNumber accountNumber2) {
        this.accountNumber2 = accountNumber2;
    }

    public SimpleStringElement getBankCode2() {
        return this.bankCode2;
    }

    public void setBankCode2(BankCode bankCode2) {
        this.bankCode2 = bankCode2;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency == null ? EUR : currency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SimpleStringElement getAccountNumber() {
        return this.accountNumber;
    }

    public SimpleStringElement getBankCode() {
        return this.bankCode;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("Currency", this.currency.getCurrencyCode(), !EUR.equals(this.currency));
        if (this.description != null) {
            ps.addAttribute("Description", this.description);
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.accountNumber instanceof AccountNumber) {
            this.accountNumber.printOut("AccountNumber", ps);
        } else {
            this.accountNumber.printOut("NationalAccountNumber", ps);
        }
        if (this.accountNumber2 != null) {
            if (this.accountNumber2 instanceof AccountNumber) {
                this.accountNumber2.printOut("AccountNumber", ps);
            } else {
                this.accountNumber2.printOut("NationalAccountNumber", ps);
            }
        }
        if (this.bankCode instanceof BankCode) {
            this.bankCode.printOut("BankCode", ps);
        } else {
            this.bankCode.printOut("NationalBankCode", ps);
        }
        if (this.bankCode2 != null) {
            if (this.bankCode2 instanceof BankCode) {
                this.bankCode2.printOut("BankCode", ps);
            } else {
                this.bankCode2.printOut("NationalBankCode", ps);
            }
        }
        ps.printOut("AccountHolder", this.accountHolder);
        ps.printOut("Amount", this.amount);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("AccountNumber")) {
                if (parser.allowChild(0)) {
                    this.accountNumber = new AccountNumber();
                    return this.accountNumber;
                }
                if (parser.allowChild(1)) {
                    this.accountNumber2 = new AccountNumber();
                    return this.accountNumber2;
                }
            }
            if (localName.equals("NationalAccountNumber")) {
                if (parser.allowChild(0)) {
                    this.accountNumber = new NationalAccountNumber();
                    return this.accountNumber;
                }
                if (parser.allowChild(1)) {
                    this.accountNumber2 = new NationalAccountNumber();
                    return this.accountNumber2;
                }
            }
            if (localName.equals("BankCode")) {
                if (parser.allowChild(0, 2)) {
                    this.bankCode = new BankCode();
                    return this.bankCode;
                }
                if (parser.allowChild(3)) {
                    this.bankCode2 = new BankCode();
                    return this.bankCode2;
                }
            }
            if (localName.equals("NationalBankCode")) {
                if (parser.allowChild(0, 2)) {
                    this.bankCode = new NationalBankcode();
                    return this.bankCode;
                }
                if (parser.allowChild(3)) {
                    this.bankCode2 = new NationalBankcode();
                    return this.bankCode2;
                }
            }
            if (localName.equals("AccountHolder") && parser.allowChild(2, 4)) {
                this.accountHolder = new SimpleStringElement();
                return this.accountHolder;
            }
            if ("Amount".equals(localName) && parser.allowChild(2, 5)) {
                this.amount = new Amount();
                return this.amount;
            }
        }
        return null;
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        this.currency = Currency.getInstance(attributes.getValueWithDefault("Currency", "EUR"));
        this.description = attributes.getValue("Description");
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }
}

