/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.AccountInfo;
import de.businesslogics.ebics.schema.orders.AddressInfo;
import de.businesslogics.ebics.schema.orders.BankInfo;
import de.businesslogics.ebics.schema.orders.OrderInfo;
import de.businesslogics.ebics.schema.types.TransferType;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class PartnerInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    final List<AccountInfo> accounts = new ArrayList<AccountInfo>();
    final List<OrderInfo> orders = new ArrayList<OrderInfo>();
    AddressInfo addressInfo;
    BankInfo bankInfo;

    @Deprecated
    public PartnerInfo() {
    }

    public PartnerInfo(AddressInfo addressInfo, BankInfo bankInfo) {
        this.addressInfo = addressInfo;
        this.bankInfo = bankInfo;
    }

    public List<AccountInfo> getAccounts() {
        return this.accounts;
    }

    public AddressInfo getAddressInfo() {
        return this.addressInfo;
    }

    public BankInfo getBankInfo() {
        return this.bankInfo;
    }

    public OrderInfo findOrderInfo(String orderType, TransferType type) {
        for (OrderInfo orderInfo : this.orders) {
            if (!orderInfo.getOrderType().getValue().equals(orderType)) continue;
            if (type == null) {
                return orderInfo;
            }
            if (!orderInfo.getTransferType().equals(type)) continue;
            return orderInfo;
        }
        return null;
    }

    public AccountInfo findAccountInfo(String bankcode, String accountNumber) {
        for (AccountInfo account : this.accounts) {
            if (!account.getAccountNumber().getValue().equals(accountNumber) || account.getBankCode() == null || !account.getBankCode().getValue().equals(bankcode)) continue;
            return account;
        }
        return null;
    }

    public List<OrderInfo> getOrders() {
        return this.orders;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.addressInfo.printOut("AddressInfo", ps);
        this.bankInfo.printOut("BankInfo", ps);
        ps.printOut("AccountInfo", this.accounts);
        ps.printOut("OrderInfo", this.orders);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if ("AddressInfo".equals(localName) && parser.allowChild(0)) {
                this.addressInfo = new AddressInfo();
                return this.addressInfo;
            }
            if ("BankInfo".equals(localName) && parser.allowChild(1)) {
                this.bankInfo = new BankInfo();
                return this.bankInfo;
            }
            if ("AccountInfo".equals(localName) && parser.allowOrIsChild(2)) {
                AccountInfo toReturn = new AccountInfo();
                this.accounts.add(toReturn);
                return toReturn;
            }
            if ("OrderInfo".equals(localName) && parser.allowOrIsChild(1, 3)) {
                OrderInfo toReturn = new OrderInfo();
                this.orders.add(toReturn);
                return toReturn;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(3);
    }
}

