/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.UserID;
import org.xml.sax.SAXException;

public class OrderSignature
extends Base64Element {
    private static final long serialVersionUID = 1L;
    private PartnerID partnerID;

    public OrderSignature() {
    }

    public OrderSignature(PartnerID partnerID, byte[] signature) {
        super(signature);
        this.partnerID = partnerID;
    }

    public PartnerID getPartnerID() {
        return this.partnerID;
    }

    public UserID getUserID() {
        return new UserID(new String(this.getValue(), 139, 8).trim());
    }

    public byte[] gerRawSignature() {
        byte[] sig = new byte[128];
        System.arraycopy(this.value, 11, sig, 0, 128);
        return sig;
    }

    public String getFilename() {
        return new String(this.value, 147, 128).trim();
    }

    @Override
    public void addAttributes(EbicsPrintStream ps) {
        super.addAttributes(ps);
        ps.addAttribute("PartnerID", this.partnerID.getValue());
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        this.partnerID = new PartnerID(attributes.getMandatoryValue("PartnerID"));
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        if (this.value.length != 512) {
            throw new SAXException("This is not a valid signature file");
        }
    }
}

