/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.IntegerElement;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.OrderDescription;
import de.businesslogics.ebics.schema.types.OrderFormat;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.TransferType;
import org.xml.sax.SAXException;

public class OrderInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private static final IntegerElement ZERO = new IntegerElement(0L);
    private OrderType orderType;
    private EbicsElement fileFormat;
    private TransferType transferType;
    private OrderFormat orderFormat;
    private OrderDescription description;
    private IntegerElement numSigRequired;

    @Deprecated
    public OrderInfo() {
        this.numSigRequired = ZERO;
    }

    public OrderInfo(OrderType orderType, TransferType transferType, OrderFormat orderFormat, OrderDescription description, IntegerElement numSigRequired) {
        this.orderType = orderType;
        this.transferType = transferType;
        this.orderFormat = orderFormat;
        this.description = description;
        this.numSigRequired = numSigRequired != null ? numSigRequired : ZERO;
    }

    public OrderInfo(OrderType orderType, OrderDescription description, IntegerElement numSigRequired) {
        this.orderType = orderType;
        this.description = description;
        this.numSigRequired = numSigRequired != null ? numSigRequired : ZERO;
    }

    public OrderDescription getDescription() {
        return this.description;
    }

    public IntegerElement getNumSigRequired() {
        return this.numSigRequired;
    }

    public OrderFormat getOrderFormat() {
        return this.orderFormat;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public FileFormat getFileFormat() {
        return (FileFormat)this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public RestrictedServiceType getService() {
        return (RestrictedServiceType)this.fileFormat;
    }

    public void setService(RestrictedServiceType service) {
        this.fileFormat = service;
    }

    public final boolean isH005AndHigher() {
        return this.fileFormat instanceof RestrictedServiceType;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.transferType != null) {
            this.orderType.printOut("OrderType", ps);
            ps.printOut("FileFormat", this.fileFormat);
            this.transferType.printOut("TransferType", ps);
            ps.printOut("OrderFormat", this.orderFormat);
        } else {
            this.orderType.printOut("AdminOrderType", ps);
            ps.printOut("Service", this.fileFormat);
        }
        this.description.printOut("Description", ps);
        if (this.numSigRequired.intValue() > 0) {
            this.numSigRequired.printOut("NumSigRequired", ps);
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            int lm;
            short pv = ProtocolVersion.fromNameSpace(uri).getVersion();
            if (pv <= 4) {
                if (localName.equals("OrderType") && parser.allowChild(0)) {
                    this.orderType = new OrderType();
                    return this.orderType;
                }
                if (localName.equals("FileFormat") && pv >= 4 && parser.allowChild(1)) {
                    this.fileFormat = new FileFormat();
                    return this.fileFormat;
                }
                if (localName.equals("TransferType") && parser.allowChild(0, 2)) {
                    this.transferType = new TransferType();
                    return this.transferType;
                }
                if (localName.equals("OrderFormat") && parser.allowChild(3)) {
                    this.orderFormat = new OrderFormat();
                    return this.orderFormat;
                }
                lm = 2;
            } else {
                if (localName.equals("AdminOrderType") && parser.allowChild(0)) {
                    this.orderType = new OrderType();
                    return this.orderType;
                }
                if (localName.equals("Service") && parser.allowChild(1)) {
                    this.fileFormat = new RestrictedServiceType();
                    return this.fileFormat;
                }
                lm = 0;
            }
            if (localName.equals("Description") && parser.allowChild(lm, 4)) {
                this.description = new OrderDescription();
                return this.description;
            }
            if (localName.equals("NumSigRequired") && parser.allowChild(5)) {
                this.numSigRequired = new IntegerElement();
                return this.numSigRequired;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(4);
    }
}

