/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.BTF;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.IntegerElement;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.String255Type;
import de.businesslogics.ebics.schema.orders.HVUOriginatorInfo;
import de.businesslogics.ebics.schema.orders.HVUSigningInfo;
import de.businesslogics.ebics.schema.orders.SignerInfo;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class OrderDetails
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    protected EbicsElement orderType;
    protected FileFormat fileFormat;
    protected OrderID orderID;
    protected IntegerElement orderDataSize;
    protected HVUSigningInfo signingInfo;
    protected final List<SignerInfo> signers = new ArrayList<SignerInfo>();
    protected HVUOriginatorInfo originatorInfo;
    protected String255Type additionalOrderInfo;

    @Deprecated
    public OrderDetails() {
    }

    public OrderDetails(OrderType orderType, OrderID orderID, IntegerElement orderDataSize, HVUSigningInfo signingInfo, HVUOriginatorInfo originatorInfo) {
        this.orderType = orderType;
        this.orderID = orderID;
        this.orderDataSize = orderDataSize;
        this.signingInfo = signingInfo;
        this.originatorInfo = originatorInfo;
    }

    public OrderDetails(RestrictedServiceType service, OrderID orderID, IntegerElement orderDataSize, HVUSigningInfo signingInfo, HVUOriginatorInfo originatorInfo) {
        this.orderType = service;
        this.orderID = orderID;
        this.orderDataSize = orderDataSize;
        this.signingInfo = signingInfo;
        this.originatorInfo = originatorInfo;
    }

    public final IntegerElement getOrderDataSize() {
        return this.orderDataSize;
    }

    public final OrderID getOrderID() {
        return this.orderID;
    }

    public final OrderType getOrderType() {
        if (this.isH004AndBelow()) {
            return (OrderType)this.orderType;
        }
        return null;
    }

    public final boolean isH004AndBelow() {
        return this.orderType instanceof OrderType;
    }

    public RestrictedServiceType getService() {
        if (!this.isH004AndBelow()) {
            return (RestrictedServiceType)this.orderType;
        }
        return null;
    }

    public String getOrderTypeOrServiceAsString() {
        if (this.isH004AndBelow()) {
            return this.getOrderType().getValue();
        }
        return BTF.toString(this.getService());
    }

    public final HVUOriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public final List<SignerInfo> getSigners() {
        return this.signers;
    }

    public final HVUSigningInfo getSigningInfo() {
        return this.signingInfo;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String255Type getAdditionalOrderInfo() {
        return this.additionalOrderInfo;
    }

    public void setAdditionalOrderInfo(String255Type additionalOrderInfo) {
        this.additionalOrderInfo = additionalOrderInfo;
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        if (this.orderType instanceof OrderType) {
            this.orderType.printOut("OrderType", ps);
            ps.printOut("FileFormat", this.fileFormat);
        } else {
            this.orderType.printOut("Service", ps);
        }
        this.orderID.printOut("OrderID", ps);
        this.orderDataSize.printOut("OrderDataSize", ps);
        this.signingInfo.printOut("SigningInfo", ps);
        ps.printOut("SignerInfo", this.signers);
        this.originatorInfo.printOut("OriginatorInfo", ps);
        ps.printOut("AdditionalOrderInfo", this.additionalOrderInfo);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            ProtocolVersion pv = ProtocolVersion.fromNameSpace(uri);
            if (pv == null || pv.getVersion() <= 4) {
                if (localName.equals("OrderType") && parser.allowChild(0)) {
                    this.orderType = new OrderType();
                    return this.orderType;
                }
                if (localName.equals("FileFormat") && (pv == null || pv.getVersion() >= 4) && parser.allowChild(1)) {
                    this.fileFormat = new FileFormat();
                    return this.fileFormat;
                }
            }
            if (pv == null || pv.getVersion() > 4) {
                if (localName.equals("Service") && parser.allowChild(0)) {
                    this.orderType = new RestrictedServiceType();
                    return this.orderType;
                }
                if (localName.equals("AdditionalOrderInfo") && parser.allowChild(7)) {
                    this.additionalOrderInfo = new String255Type();
                    return this.additionalOrderInfo;
                }
            }
            if (localName.equals("OrderID") && parser.allowChild(0, 2)) {
                this.orderID = new OrderID();
                return this.orderID;
            }
            if (localName.equals("OrderDataSize") && parser.allowChild(3)) {
                this.orderDataSize = new IntegerElement();
                return this.orderDataSize;
            }
            if (localName.equals("SigningInfo") && parser.allowChild(4)) {
                this.signingInfo = new HVUSigningInfo();
                return this.signingInfo;
            }
            if (localName.equals("SignerInfo") && parser.allowOrIsChild(5)) {
                SignerInfo toReturn = new SignerInfo();
                this.signers.add(toReturn);
                return toReturn;
            }
            if (localName.equals("OriginatorInfo") && parser.allowChild(4, 6)) {
                this.originatorInfo = new HVUOriginatorInfo();
                return this.originatorInfo;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(6);
    }
}

