/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h005.ServiceType;
import de.businesslogics.ebics.schema.types.OrderTListType;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.xml.sax.SAXException;

public class HVZOrderParams
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private Object orderTypes;

    public HVZOrderParams() {
    }

    public HVZOrderParams(OrderTListType orderTypes) {
        this.orderTypes = orderTypes;
    }

    public OrderTListType getOrderTypes() {
        return (OrderTListType)this.orderTypes;
    }

    public List<ServiceType> getServiceFilters() {
        if (this.orderTypes == null) {
            this.orderTypes = new ArrayList();
        }
        return (List)this.orderTypes;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.orderTypes instanceof OrderTListType) {
            ((OrderTListType)this.orderTypes).printOut("OrderTypes", ps);
        } else if (this.orderTypes != null) {
            ps.printElements(null, "ServiceFilter", this.getServiceFilters());
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (!parser.isParentUri(uri)) {
            return null;
        }
        short pv = ProtocolVersion.fromNameSpace(uri).getVersion();
        if (pv <= 4) {
            if (localName.equals("OrderTypes") && parser.allowChild(0)) {
                OrderTListType toReturn = new OrderTListType();
                this.orderTypes = toReturn;
                return toReturn;
            }
        } else if (localName.equals("ServiceFilter") && parser.allowOrIsChild(0)) {
            ServiceType toReturn = new ServiceType();
            this.getServiceFilters().add(toReturn);
            return toReturn;
        }
        return null;
    }

    @Override
    public String name() {
        return "HVZOrderParams";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.orderTypes == null ? 0 : (this.orderTypes instanceof OrderTListType ? this.getOrderTypes().hashCode() : this.getServiceFilters().hashCode()));
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HVZOrderParams)) {
            return false;
        }
        HVZOrderParams other = (HVZOrderParams)obj;
        return Objects.equals(this.orderTypes, other.orderTypes);
    }
}

