/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.BooleanElement;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.IntegerElement;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.String255Type;
import de.businesslogics.ebics.schema.orders.HVUOriginatorInfo;
import de.businesslogics.ebics.schema.orders.HVUSigningInfo;
import de.businesslogics.ebics.schema.orders.OrderDetails;
import de.businesslogics.ebics.schema.orders.SignerInfo;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.AccountNumber;
import de.businesslogics.ebics.schema.types.AmountValue;
import de.businesslogics.ebics.schema.types.BankCode;
import de.businesslogics.ebics.schema.types.CurrencyBase;
import de.businesslogics.ebics.schema.types.DataDigest;
import de.businesslogics.ebics.schema.types.NationalAccountNumber;
import de.businesslogics.ebics.schema.types.NationalBankcode;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.math.BigDecimal;
import org.xml.sax.SAXException;

public class HVZOrderDetails
extends OrderDetails {
    private static final long serialVersionUID = 1L;
    protected DataDigest dataDigest;
    protected BooleanElement orderDataAvailable;
    protected BooleanElement orderDetailsAvailable;
    protected IntegerElement totalOrders;
    protected TotalAmount totalAmount;
    protected CurrencyBase currency;
    protected FirstOrderInfo firstOrderInfo;

    @Deprecated
    public HVZOrderDetails() {
    }

    public HVZOrderDetails(OrderType orderType, OrderID orderID, DataDigest dataDigest, BooleanElement orderDataAvailable, IntegerElement orderDataSize, BooleanElement orderDetailsAvailable, HVUSigningInfo signingInfo, HVUOriginatorInfo originatorInfo) {
        super(orderType, orderID, orderDataSize, signingInfo, originatorInfo);
        this.orderDataAvailable = orderDataAvailable;
        this.dataDigest = dataDigest;
        this.orderDetailsAvailable = orderDetailsAvailable;
    }

    public HVZOrderDetails(RestrictedServiceType service, OrderID orderID, DataDigest dataDigest, BooleanElement orderDataAvailable, IntegerElement orderDataSize, BooleanElement orderDetailsAvailable, HVUSigningInfo signingInfo, HVUOriginatorInfo originatorInfo) {
        super(service, orderID, orderDataSize, signingInfo, originatorInfo);
        this.orderDataAvailable = orderDataAvailable;
        this.dataDigest = dataDigest;
        this.orderDetailsAvailable = orderDetailsAvailable;
    }

    public IntegerElement getTotalOrders() {
        return this.totalOrders;
    }

    public void setTotalOrders(IntegerElement totalOrders) {
        this.totalOrders = totalOrders;
    }

    public TotalAmount getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(TotalAmount totalAmount) {
        this.totalAmount = totalAmount;
    }

    public CurrencyBase getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyBase currency) {
        this.currency = currency;
    }

    public FirstOrderInfo getFirstOrderInfo() {
        return this.firstOrderInfo;
    }

    public void setFirstOrderInfo(FirstOrderInfo firstOrderInfo) {
        this.firstOrderInfo = firstOrderInfo;
    }

    public DataDigest getDataDigest() {
        return this.dataDigest;
    }

    public BooleanElement getOrderDataAvailable() {
        return this.orderDataAvailable;
    }

    public BooleanElement getOrderDetailsAvailable() {
        return this.orderDetailsAvailable;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.orderType instanceof OrderType) {
            this.orderType.printOut("OrderType", ps);
            ps.printOut("FileFormat", this.fileFormat);
        } else {
            this.orderType.printOut("Service", ps);
        }
        this.orderID.printOut("OrderID", ps);
        if (this.dataDigest != null) {
            this.dataDigest.printOut("DataDigest", ps);
        }
        this.orderDataAvailable.printOut("OrderDataAvailable", ps);
        this.orderDataSize.printOut("OrderDataSize", ps);
        this.orderDetailsAvailable.printOut("OrderDetailsAvailable", ps);
        if (this.totalOrders != null) {
            this.totalOrders.printOut("TotalOrders", ps);
        }
        if (this.totalAmount != null) {
            this.totalAmount.printOut("TotalAmount", ps);
        }
        if (this.currency != null) {
            this.currency.printOut("Currency", ps);
        }
        if (this.firstOrderInfo != null) {
            this.firstOrderInfo.printOut("FirstOrderInfo", ps);
        }
        this.signingInfo.printOut("SigningInfo", ps);
        ps.printOut("SignerInfo", this.signers);
        this.originatorInfo.printOut("OriginatorInfo", ps);
        ps.printOut("AdditionalOrderInfo", this.additionalOrderInfo);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            short pv = ProtocolVersion.fromNameSpace(uri).getVersion();
            if (pv <= 4) {
                if (localName.equals("OrderType") && parser.allowChild(0)) {
                    this.orderType = new OrderType();
                    return this.orderType;
                }
                if (localName.equals("FileFormat") && pv >= 4 && parser.allowChild(1)) {
                    this.fileFormat = new FileFormat();
                    return this.fileFormat;
                }
            } else {
                if (localName.equals("Service") && parser.allowChild(0)) {
                    this.orderType = new RestrictedServiceType();
                    return this.orderType;
                }
                if (localName.equals("AdditionalOrderInfo") && parser.allowChild(14)) {
                    this.additionalOrderInfo = new String255Type();
                    return this.additionalOrderInfo;
                }
            }
            if (localName.equals("OrderType") && parser.allowChild(0)) {
                this.orderType = new OrderType();
                return this.orderType;
            }
            if (localName.equals("FileFormat") && pv >= 4 && parser.allowChild(1)) {
                this.fileFormat = new FileFormat();
                return this.fileFormat;
            }
            if (localName.equals("OrderID") && parser.allowChild(0, 2)) {
                this.orderID = new OrderID();
                return this.orderID;
            }
            if (localName.equals("DataDigest") && parser.allowChild(3)) {
                this.dataDigest = new DataDigest();
                return this.dataDigest;
            }
            if (localName.equals("OrderDataAvailable") && parser.allowChild(4)) {
                this.orderDataAvailable = new BooleanElement();
                return this.orderDataAvailable;
            }
            if (localName.equals("OrderDataSize") && parser.allowChild(5)) {
                this.orderDataSize = new IntegerElement();
                return this.orderDataSize;
            }
            if (localName.equals("OrderDetailsAvailable") && parser.allowChild(6)) {
                this.orderDetailsAvailable = new BooleanElement();
                return this.orderDetailsAvailable;
            }
            if (localName.equals("TotalOrders") && parser.allowChild(7)) {
                this.totalOrders = new IntegerElement();
                return this.totalOrders;
            }
            if (localName.equals("TotalAmount") && parser.allowChild(6, 8)) {
                this.totalAmount = new TotalAmount();
                return this.totalAmount;
            }
            if (localName.equals("Currency") && parser.allowChild(7, 9)) {
                this.currency = new CurrencyBase();
                return this.currency;
            }
            if (localName.equals("FirstOrderInfo") && parser.allowChild(6, 10)) {
                this.firstOrderInfo = new FirstOrderInfo();
                return this.firstOrderInfo;
            }
            if (localName.equals("SigningInfo") && parser.allowChild(6, 11)) {
                this.signingInfo = new HVUSigningInfo();
                return this.signingInfo;
            }
            if (localName.equals("SignerInfo") && parser.allowOrIsChild(12)) {
                SignerInfo toReturn = new SignerInfo();
                this.signers.add(toReturn);
                return toReturn;
            }
            if (localName.equals("OriginatorInfo") && parser.allowChild(11, 13)) {
                this.originatorInfo = new HVUOriginatorInfo();
                return this.originatorInfo;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(13);
    }

    public static class TotalAmount
    extends AmountValue {
        private static final long serialVersionUID = 1L;
        private BooleanElement credit;

        @Deprecated
        private TotalAmount() {
        }

        public TotalAmount(BigDecimal value) {
            super(value);
        }

        public BooleanElement isCredit() {
            return this.credit;
        }

        public void setCredit(BooleanElement credit) {
            this.credit = credit;
        }

        @Override
        protected void addAttributes(EbicsPrintStream ps) {
            if (this.credit != null) {
                ps.addAttribute("isCredit", this.credit.toString());
            }
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.credit = attributes.setValue("isCredit", BooleanElement.class);
        }
    }

    public static class FirstOrderInfo
    extends EbicsElement {
        private static final long serialVersionUID = 1L;
        private SimpleStringElement orderPartyInfo;
        private AccountInfo accountInfo;

        @Override
        public void printValue(EbicsPrintStream ps) {
            ps.printOut("OrderPartyInfo", this.orderPartyInfo);
            ps.printOut("AccountInfo", this.accountInfo);
        }

        public AccountInfo getAccountInfo() {
            return this.accountInfo;
        }

        public void setAccountInfo(AccountInfo accountInfo) {
            this.accountInfo = accountInfo;
        }

        public SimpleStringElement getOrderPartyInfo() {
            return this.orderPartyInfo;
        }

        public void setOrderPartyInfo(SimpleStringElement orderPartyInfo) {
            this.orderPartyInfo = orderPartyInfo;
        }

        @Override
        protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
            if (parser.isParentUri(uri)) {
                if ("OrderPartyInfo".equals(localName) && parser.allowChild(0)) {
                    this.orderPartyInfo = new SimpleStringElement();
                    return this.orderPartyInfo;
                }
                if ("AccountInfo".equals(localName) && parser.allowChild(-1, 1)) {
                    this.accountInfo = new AccountInfo();
                    return this.accountInfo;
                }
            }
            return null;
        }
    }

    public static class AccountInfo
    extends EbicsElement {
        private static final long serialVersionUID = 1L;
        SimpleStringElement accountNumber;
        SimpleStringElement accountNumber2;
        SimpleStringElement bankCode;
        SimpleStringElement bankCode2;

        @Deprecated
        public AccountInfo() {
        }

        public AccountInfo(SimpleStringElement accountNumber) {
            this.accountNumber = accountNumber;
        }

        public SimpleStringElement getAccountNumber2() {
            return this.accountNumber2;
        }

        public void setAccountNumber2(SimpleStringElement accountNumber2) {
            this.accountNumber2 = accountNumber2;
        }

        public SimpleStringElement getBankCode2() {
            return this.bankCode2;
        }

        public void setBankCode2(SimpleStringElement bankCode2) {
            this.bankCode2 = bankCode2;
        }

        public SimpleStringElement getAccountNumber() {
            return this.accountNumber;
        }

        public SimpleStringElement getBankCode() {
            return this.bankCode;
        }

        public void setBankCode(SimpleStringElement bankCode) {
            this.bankCode = bankCode;
        }

        @Override
        public void printValue(EbicsPrintStream ps) {
            if (this.accountNumber instanceof AccountNumber) {
                this.accountNumber.printOut("AccountNumber", ps);
            } else {
                this.accountNumber.printOut("NationalAccountNumber", ps);
            }
            if (this.accountNumber2 != null) {
                if (this.accountNumber2 instanceof AccountNumber) {
                    this.accountNumber2.printOut("AccountNumber", ps);
                } else {
                    this.accountNumber2.printOut("NationalAccountNumber", ps);
                }
            }
            if (this.bankCode != null) {
                if (this.bankCode instanceof BankCode) {
                    this.bankCode.printOut("BankCode", ps);
                } else {
                    this.bankCode.printOut("NationalBankCode", ps);
                }
            }
            if (this.bankCode2 != null) {
                if (this.bankCode2 instanceof BankCode) {
                    this.bankCode2.printOut("BankCode", ps);
                } else {
                    this.bankCode2.printOut("NationalBankCode", ps);
                }
            }
        }

        @Override
        protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
            if (parser.isParentUri(uri)) {
                if (localName.equals("AccountNumber")) {
                    if (parser.allowChild(0)) {
                        this.accountNumber = new AccountNumber();
                        return this.accountNumber;
                    }
                    if (parser.allowChild(1)) {
                        this.accountNumber2 = new AccountNumber();
                        return this.accountNumber2;
                    }
                }
                if (localName.equals("NationalAccountNumber")) {
                    if (parser.allowChild(0)) {
                        this.accountNumber = new NationalAccountNumber();
                        return this.accountNumber;
                    }
                    if (parser.allowChild(1)) {
                        this.accountNumber2 = new NationalAccountNumber();
                        return this.accountNumber2;
                    }
                }
                if (localName.equals("BankCode")) {
                    if (parser.allowChild(0, 2)) {
                        this.bankCode = new BankCode();
                        return this.bankCode;
                    }
                    if (parser.allowChild(3)) {
                        this.bankCode2 = new BankCode();
                        return this.bankCode2;
                    }
                }
                if (localName.equals("NationalBankCode")) {
                    if (parser.allowChild(0, 2)) {
                        this.bankCode = new NationalBankcode();
                        return this.bankCode;
                    }
                    if (parser.allowChild(3)) {
                        this.bankCode2 = new NationalBankcode();
                        return this.bankCode2;
                    }
                }
            }
            return null;
        }

        @Override
        protected void endElement(ElementParser parser) throws SAXException {
            ProtocolVersion pv = ProtocolVersion.fromNameSpace(parser.getParentUri());
            parser.checkLastMandatory(pv.compareTo(ProtocolVersion.H005) < 0 ? 2 : 0);
        }
    }
}

