/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.orders.HVDOrderParams;
import de.businesslogics.ebics.schema.orders.HVTOrderFlags;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.Parameter;
import de.businesslogics.ebics.schema.types.PartnerID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.xml.sax.SAXException;

public class HVTOrderParams
extends HVDOrderParams {
    private static final long serialVersionUID = 1L;
    private HVTOrderFlags orderFlags;
    private List<Parameter> parameters;

    @Deprecated
    public HVTOrderParams() {
        this.parameters = new ArrayList<Parameter>();
    }

    public HVTOrderParams(PartnerID partnerID, OrderType orderType, OrderID orderID, HVTOrderFlags orderFlags) {
        super(partnerID, orderType, orderID);
        this.orderFlags = orderFlags;
        this.parameters = Collections.emptyList();
    }

    public HVTOrderParams(PartnerID partnerID, RestrictedServiceType service, OrderID orderID, HVTOrderFlags orderFlags) {
        super(partnerID, service, orderID);
        this.orderFlags = orderFlags;
        this.parameters = Collections.emptyList();
    }

    public HVTOrderFlags getOrderFlags() {
        return this.orderFlags;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        super.printValue(ps);
        this.orderFlags.printOut("OrderFlags", ps);
        ps.printOut("Parameter", this.parameters);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        EbicsElement toReturn = super.createChild(parser, uri, localName, qName);
        if (toReturn != null) {
            return toReturn;
        }
        if (parser.isParentUri(uri)) {
            if (localName.equals("OrderFlags") && parser.allowChild(4)) {
                this.orderFlags = new HVTOrderFlags();
                return this.orderFlags;
            }
            if (localName.equals("Parameter") && parser.allowOrIsChild(5)) {
                Parameter p = new Parameter();
                this.parameters.add(p);
                return p;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(4);
    }

    @Override
    public String name() {
        return "HVTOrderParams";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.orderFlags == null ? 0 : this.orderFlags.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof HVTOrderParams)) {
            return false;
        }
        HVTOrderParams other = (HVTOrderParams)obj;
        return super.equals(obj) && Objects.equals(this.orderFlags, other.orderFlags) && Objects.equals(this.parameters, other.parameters);
    }
}

