/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.h005.MessageType;
import de.businesslogics.ebics.schema.types.AmountValue;
import de.businesslogics.ebics.schema.types.AttributedAccount;
import de.businesslogics.ebics.schema.types.OrderFormat;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class HVTOrderInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private EbicsElement orderFormat;
    private final List<AttributedAccount> accountInfos = new ArrayList<AttributedAccount>(2);
    private XMLDate executionDate;
    private MyAmount amount;
    private final List<MyDescription> descriptions = new ArrayList<MyDescription>();

    @Deprecated
    public HVTOrderInfo() {
    }

    public HVTOrderInfo(MyAmount amount) {
        this.amount = amount;
    }

    public OrderFormat getOrderFormat() {
        return this.orderFormat instanceof OrderFormat ? (OrderFormat)this.orderFormat : null;
    }

    public void setOrderFormat(OrderFormat orderFormat) {
        this.orderFormat = orderFormat;
    }

    public MessageType getMsgName() {
        return this.orderFormat instanceof MessageType ? (MessageType)this.orderFormat : null;
    }

    public void setMsgName(MessageType msgName) {
        this.orderFormat = msgName;
    }

    public XMLDate getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(XMLDate executionDate) {
        this.executionDate = executionDate;
    }

    public List<MyDescription> getDescriptions() {
        return this.descriptions;
    }

    public List<AttributedAccount> getAccountInfos() {
        return this.accountInfos;
    }

    public MyAmount getAmount() {
        return this.amount;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        short pv = ProtocolVersion.fromNameSpace(ps.getNamespaceURI("")).getVersion();
        if (pv < 5) {
            if (this.orderFormat instanceof OrderFormat) {
                this.orderFormat.printOut("OrderFormat", ps);
            }
        } else if (this.orderFormat instanceof MessageType) {
            this.orderFormat.printOut("MsgName", ps);
        }
        ps.printOut("AccountInfo", this.accountInfos);
        ps.printOut("ExecutionDate", this.executionDate);
        ps.printOut("Amount", this.amount);
        ps.printOut("Description", this.descriptions);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (parser.isParentUri(uri)) {
            short pv = ProtocolVersion.fromNameSpace(uri).getVersion();
            if (pv <= 4) {
                if ("OrderFormat".equals(localName) && parser.allowChild(0)) {
                    this.orderFormat = new OrderFormat();
                    return this.orderFormat;
                }
            } else if ("MsgName".equals(localName) && parser.allowChild(0)) {
                this.orderFormat = new MessageType();
                return this.orderFormat;
            }
            if ("AccountInfo".equals(localName) && (parser.allowChild(-1, 1) || parser.allowChild(2) || parser.allowChild(3))) {
                AttributedAccount toReturn = new AttributedAccount();
                this.accountInfos.add(toReturn);
                return toReturn;
            }
            if ("ExecutionDate".equals(localName) && parser.allowChild(2, 4)) {
                this.executionDate = new XMLDate();
                return this.executionDate;
            }
            if ("Amount".equals(localName) && parser.allowChild(2, 5)) {
                this.amount = new MyAmount();
                return this.amount;
            }
            if ("Description".equals(localName) && (parser.allowChild(6) || parser.allowChild(7) || parser.allowChild(8) || parser.allowChild(9))) {
                MyDescription toReturn = new MyDescription();
                this.descriptions.add(toReturn);
                return toReturn;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(5);
    }

    public static class MyAmount
    extends AmountValue {
        private static final long serialVersionUID = 1L;
        private Boolean credit;
        private Currency currency;

        private MyAmount() {
        }

        public MyAmount(BigDecimal value) {
            super(value);
        }

        public Boolean getCredit() {
            return this.credit;
        }

        public void setCredit(Boolean credit) {
            this.credit = credit;
        }

        public Currency getCurrency() {
            return this.currency;
        }

        public void setCurrency(Currency currency) {
            this.currency = currency;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            if (this.credit != null) {
                ps.addAttribute("isCredit", this.credit.toString());
            }
            if (this.currency != null) {
                ps.addAttribute("Currency", this.currency.toString());
            }
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            String s = attributes.getValue("isCredit");
            if (s != null) {
                this.credit = Boolean.valueOf(s);
            }
            if ((s = attributes.getValue("Currency")) != null) {
                this.currency = Currency.getInstance(s);
            }
        }
    }

    public static class MyDescription
    extends SimpleStringElement {
        private static final long serialVersionUID = 1L;
        private DescriptionType type;

        private MyDescription() {
        }

        public MyDescription(String value, DescriptionType type) {
            super(value);
            this.type = type;
        }

        public DescriptionType getType() {
            return this.type;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            ps.addAttribute("Type", this.type.name());
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            String s = attributes.getMandatoryValue("Type");
            try {
                this.type = DescriptionType.valueOf(s);
            }
            catch (IllegalArgumentException iae) {
                throw new SAXException("Unknown description type " + s);
            }
        }
    }

    public static enum DescriptionType {
        Purpose,
        Details,
        Comment;

    }
}

