/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.Objects;
import org.xml.sax.SAXException;

public class HVDOrderParams
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private PartnerID partnerID;
    private OrderType orderType;
    private OrderID orderID;
    private FileFormat fileFormat;
    private RestrictedServiceType service;

    @Deprecated
    public HVDOrderParams() {
    }

    public HVDOrderParams(PartnerID partnerID, OrderType orderType, OrderID orderID) {
        this.partnerID = partnerID;
        this.orderType = orderType;
        this.orderID = orderID;
    }

    public HVDOrderParams(PartnerID partnerID, RestrictedServiceType service, OrderID orderID) {
        this.partnerID = partnerID;
        this.service = service;
        this.orderID = orderID;
    }

    public OrderID getOrderID() {
        return this.orderID;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public RestrictedServiceType getService() {
        return this.service;
    }

    public PartnerID getPartnerID() {
        return this.partnerID;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.partnerID.printOut("PartnerID", ps);
        if (this.orderType != null) {
            this.orderType.printOut("OrderType", ps);
            ps.printOut("FileFormat", this.fileFormat);
        } else {
            this.service.printOut("Service", ps);
        }
        this.orderID.printOut("OrderID", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (!parser.isParentUri(uri)) {
            return null;
        }
        short pv = ProtocolVersion.fromNameSpace(uri).getVersion();
        if (localName.equals("PartnerID") && parser.allowChild(0)) {
            this.partnerID = new PartnerID();
            return this.partnerID;
        }
        if (pv <= 4) {
            if (localName.equals("OrderType") && parser.allowChild(1)) {
                this.orderType = new OrderType();
                return this.orderType;
            }
            if (localName.equals("FileFormat") && pv >= 4 && parser.allowChild(2)) {
                this.fileFormat = new FileFormat();
                return this.fileFormat;
            }
        } else if (localName.equals("Service") && parser.allowChild(1)) {
            this.service = new RestrictedServiceType();
            return this.service;
        }
        if (localName.equals("OrderID") && parser.allowChild(1, 3)) {
            this.orderID = new OrderID();
            return this.orderID;
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(3);
    }

    @Override
    public String name() {
        return "HVDOrderParams";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileFormat == null ? 0 : this.fileFormat.hashCode());
        result = 31 * result + (this.orderType == null ? 0 : this.orderType.hashCode());
        result = 31 * result + (this.partnerID == null ? 0 : this.partnerID.hashCode());
        result = 31 * result + (this.orderID == null ? 0 : this.orderID.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HVDOrderParams)) {
            return false;
        }
        HVDOrderParams other = (HVDOrderParams)obj;
        return Objects.equals(this.fileFormat, other.fileFormat) && Objects.equals(this.orderType, other.orderType) && Objects.equals(this.partnerID, other.partnerID) && Objects.equals(this.orderID, other.orderID) && Objects.equals(this.service, other.service);
    }
}

