/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.AccountInfo;
import de.businesslogics.ebics.schema.orders.OrderInfo;
import de.businesslogics.ebics.schema.orders.PartnerInfo;
import de.businesslogics.ebics.schema.orders.UserInfo;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.TransferType;
import org.xml.sax.SAXException;

public class HTDResponseOrderData
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    private final ProtocolVersion version;
    private PartnerInfo partnerInfo;
    private UserInfo userInfo;

    public HTDResponseOrderData(ProtocolVersion version) {
        this.version = version;
    }

    public HTDResponseOrderData(ProtocolVersion protocolVersion, PartnerInfo partnerInfo, UserInfo userInfo) {
        this.version = protocolVersion;
        this.partnerInfo = partnerInfo;
        this.userInfo = userInfo;
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
    }

    public OrderInfo findOrderInfo(String orderType, TransferType type) {
        if (this.partnerInfo == null) {
            return null;
        }
        return this.partnerInfo.findOrderInfo(orderType, type);
    }

    public AccountInfo findAccountInfo(String bankcode, String accountNumber) {
        if (this.partnerInfo == null) {
            return null;
        }
        return this.partnerInfo.findAccountInfo(bankcode, accountNumber);
    }

    public PartnerInfo getPartnerInfo() {
        return this.partnerInfo;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public String name() {
        return "HTDResponseOrderData";
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.partnerInfo.printOut("PartnerInfo", ps);
        this.userInfo.printOut("UserInfo", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("PartnerInfo") && parser.allowChild(0)) {
                this.partnerInfo = new PartnerInfo();
                return this.partnerInfo;
            }
            if (localName.equals("UserInfo") && parser.allowChild(1)) {
                this.userInfo = new UserInfo();
                return this.userInfo;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }
}

