/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.EmptyElement;
import de.businesslogics.ebics.schema.orders.HPDVersion;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import org.xml.sax.SAXException;

public class HPDProtocolParams
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private HPDVersion version;
    private OptSupport recovery;
    private OptSupport preValidation;
    private OptSupport clientDataDownload;
    private OptSupport downloadableOrderData;
    private X509Support x509Data;

    @Deprecated
    public HPDProtocolParams() {
    }

    public HPDProtocolParams(HPDVersion version) {
        this.version = version;
    }

    public HPDVersion getVersion() {
        return this.version;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.version.printOut("Version", ps);
        if (this.isRecovery()) {
            this.recovery.printOut("Recovery", ps);
        }
        if (this.isPreValidation()) {
            this.preValidation.printOut("PreValidation", ps);
        }
        if (HPDProtocolParams.is(this.x509Data)) {
            this.x509Data.printOut("X509Data", ps);
        }
        if (this.isClientDataDownload()) {
            this.clientDataDownload.printOut("ClientDataDownload", ps);
        }
        if (this.isDownloadableOrderData()) {
            this.downloadableOrderData.printOut("DownloadableOrderData", ps);
        }
    }

    public boolean isRecovery() {
        return HPDProtocolParams.is(this.recovery);
    }

    public void setRecovery(boolean b) {
        this.recovery = OptSupport.getInstance(b);
    }

    public boolean isPreValidation() {
        return HPDProtocolParams.is(this.preValidation);
    }

    public void setPreValidation(boolean b) {
        this.preValidation = OptSupport.getInstance(b);
    }

    public X509Support getX509Data() {
        return this.x509Data;
    }

    public void setX509Data(X509Support data) {
        this.x509Data = data;
    }

    public boolean isClientDataDownload() {
        return HPDProtocolParams.is(this.clientDataDownload);
    }

    public void setClientDataDownload(boolean b) {
        this.clientDataDownload = OptSupport.getInstance(b);
    }

    public boolean isDownloadableOrderData() {
        return HPDProtocolParams.is(this.downloadableOrderData);
    }

    public void setDownloadableOrderData(boolean b) {
        this.downloadableOrderData = OptSupport.getInstance(b);
    }

    private static boolean is(OptSupport os) {
        return os != null ? os.isSupported() : false;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) {
        if (parser.isParentUri(uri)) {
            short pv = ProtocolVersion.fromNameSpace(uri).getVersion();
            if (localName.equals("Version") && parser.allowChild(0)) {
                this.version = new HPDVersion();
                return this.version;
            }
            if (localName.equals("Recovery") && parser.allowChild(1)) {
                this.recovery = new OptSupport();
                return this.recovery;
            }
            if (localName.equals("PreValidation") && parser.allowChild(0, 2)) {
                this.preValidation = new OptSupport();
                return this.preValidation;
            }
            if (pv < 5 && localName.equals("X509Data") && parser.allowChild(0, 3)) {
                this.x509Data = new X509Support();
                return this.x509Data;
            }
            if (localName.equals("ClientDataDownload") && parser.allowChild(0, 4)) {
                this.clientDataDownload = new OptSupport();
                return this.clientDataDownload;
            }
            if (localName.equals("DownloadableOrderData") && parser.allowChild(0, 5)) {
                this.downloadableOrderData = new OptSupport();
                return this.downloadableOrderData;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }

    public static class OptSupport
    extends EmptyElement {
        private static final long serialVersionUID = 1L;
        protected boolean supported;
        public static final OptSupport SUPPORTED = new OptSupport(true);
        public static final OptSupport NOT_SUPPORTED = new OptSupport(false);

        OptSupport() {
        }

        protected OptSupport(boolean supported) {
            this.supported = supported;
        }

        public static OptSupport getInstance(boolean supported) {
            return supported ? SUPPORTED : NOT_SUPPORTED;
        }

        public boolean isSupported() {
            return this.supported;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            ps.addAttribute("supported", Boolean.toString(this.supported), !this.supported);
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.supported = attributes.getBoolean("supported", true);
        }

        protected Object readResolve() {
            return this.supported ? SUPPORTED : NOT_SUPPORTED;
        }
    }

    public static class X509Support
    extends OptSupport {
        private static final long serialVersionUID = 1L;
        private boolean persistent = false;

        public X509Support() {
            super(true);
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setSupported(boolean b) {
            this.supported = b;
        }

        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            super.addAttributes(ps);
            ps.addAttribute("persistent", Boolean.toString(this.persistent), this.persistent);
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            super.setAttributes(attributes);
            this.persistent = attributes.getBoolean("persistent", false);
        }

        @Override
        protected Object readResolve() {
            return this;
        }
    }
}

