/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.HostID;
import de.businesslogics.ebics.schema.types.TimeStamp;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class HPDAccessParams
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private final List<HPDUrl> urls;
    private SimpleStringElement institute;
    private HostID hostID;

    @Deprecated
    public HPDAccessParams() {
        this.urls = new ArrayList<HPDUrl>();
    }

    public HPDAccessParams(List<HPDUrl> urls, SimpleStringElement institute) {
        this.urls = urls;
        this.institute = institute;
    }

    public HostID getHostID() {
        return this.hostID;
    }

    public void setHostID(HostID hostID) {
        this.hostID = hostID;
    }

    public SimpleStringElement getInstitute() {
        return this.institute;
    }

    public List<HPDUrl> getUrls() {
        return this.urls;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        for (HPDUrl url : this.urls) {
            url.printOut("URL", ps);
        }
        this.institute.printOut("Institute", ps);
        if (this.hostID != null) {
            this.hostID.printOut("HostID", ps);
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("URL") && parser.allowOrIsChild(0)) {
                HPDUrl o = new HPDUrl();
                this.urls.add(o);
                return o;
            }
            if (localName.equals("Institute") && !this.urls.isEmpty() && parser.allowChild(1)) {
                this.institute = new SimpleStringElement();
                return this.institute;
            }
            if (localName.equals("HostID") && parser.allowChild(2)) {
                this.hostID = new HostID();
                return this.hostID;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    public static class HPDUrl
    extends SimpleStringElement {
        private static final long serialVersionUID = 1L;
        private Date validFrom;

        @Deprecated
        public HPDUrl() {
        }

        public HPDUrl(String url) {
            super(url);
        }

        public URL getURL() throws MalformedURLException {
            return new URL(this.value);
        }

        public Date getValidFrom() {
            return this.validFrom;
        }

        public void setValidFrom(Date validFrom) {
            this.validFrom = validFrom;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            if (this.validFrom != null) {
                ps.addAttribute("valid_from", TimeStamp.toString(this.validFrom));
            }
        }

        @Override
        protected void endElement(ElementParser parser) throws SAXException {
            this.value = ((SimpleStringElement.StringParser)parser).getCondensed();
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            String s = attributes.getValue("valid_from");
            if (s != null && s.length() > 0) {
                try {
                    this.validFrom = TimeStamp.fromString(s);
                }
                catch (ParseException pe) {
                    throw new SAXException(s + " is no valid date", pe);
                }
            }
        }
    }
}

