/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.OrderInfo;
import de.businesslogics.ebics.schema.orders.PartnerInfo;
import de.businesslogics.ebics.schema.orders.UserInfo;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.TransferType;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class HKDResponseOrderData
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    private final ProtocolVersion version;
    private PartnerInfo partnerInfo;
    private final List<UserInfo> userInfos;

    public HKDResponseOrderData(ProtocolVersion version) {
        this.version = version;
        this.userInfos = new ArrayList<UserInfo>();
    }

    public HKDResponseOrderData(ProtocolVersion protocolVersion, PartnerInfo partnerInfo, List<UserInfo> userInfos) {
        this.version = protocolVersion;
        this.partnerInfo = partnerInfo;
        this.userInfos = userInfos;
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
    }

    public PartnerInfo getPartnerInfo() {
        return this.partnerInfo;
    }

    public List<UserInfo> getUserInfos() {
        return this.userInfos;
    }

    @Override
    public String name() {
        return "HKDResponseOrderData";
    }

    public OrderInfo findOrderInfo(String orderType, TransferType type) {
        if (this.partnerInfo == null) {
            return null;
        }
        return this.partnerInfo.findOrderInfo(orderType, type);
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.partnerInfo.printOut("PartnerInfo", ps);
        ps.printOut("UserInfo", this.userInfos);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("PartnerInfo") && parser.allowChild(0)) {
                this.partnerInfo = new PartnerInfo();
                return this.partnerInfo;
            }
            if (localName.equals("UserInfo") && parser.allowOrIsChild(1)) {
                UserInfo toReturn = new UserInfo();
                this.userInfos.add(toReturn);
                return toReturn;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }
}

