/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.AuthenticationPubKeyInfo;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyInfo;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.UserID;
import org.xml.sax.SAXException;

public class HCARequestOrderData
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    private final ProtocolVersion version;
    private AuthenticationPubKeyInfo authenticationPubKeyInfo;
    private EncryptionPubKeyInfo encryptionPubKeyInfo;
    private PartnerID partnerID;
    private UserID userID;

    public HCARequestOrderData(ProtocolVersion version) {
        this.version = version;
    }

    public HCARequestOrderData(ProtocolVersion protocolVersion, AuthenticationPubKeyInfo authenticationPubKeyInfo, EncryptionPubKeyInfo encryptionPubKeyInfo, PartnerID partnerID, UserID userID) {
        this.version = protocolVersion;
        this.authenticationPubKeyInfo = authenticationPubKeyInfo;
        this.encryptionPubKeyInfo = encryptionPubKeyInfo;
        this.partnerID = partnerID;
        this.userID = userID;
    }

    public AuthenticationPubKeyInfo getAuthenticationPubKeyInfo() {
        return this.authenticationPubKeyInfo;
    }

    public EncryptionPubKeyInfo getEncryptionPubKeyInfo() {
        return this.encryptionPubKeyInfo;
    }

    public PartnerID getPartnerID() {
        return this.partnerID;
    }

    public UserID getUserID() {
        return this.userID;
    }

    @Override
    public String name() {
        return "HCARequestOrderData";
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.authenticationPubKeyInfo.printOut("AuthenticationPubKeyInfo", ps);
        this.encryptionPubKeyInfo.printOut("EncryptionPubKeyInfo", ps);
        this.partnerID.printOut("PartnerID", ps);
        this.userID.printOut("UserID", ps);
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
        ps.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("AuthenticationPubKeyInfo") && parser.allowChild(0)) {
                this.authenticationPubKeyInfo = new AuthenticationPubKeyInfo();
                return this.authenticationPubKeyInfo;
            }
            if (localName.equals("EncryptionPubKeyInfo") && parser.allowChild(1)) {
                this.encryptionPubKeyInfo = new EncryptionPubKeyInfo();
                return this.encryptionPubKeyInfo;
            }
            if (localName.equals("PartnerID") && parser.allowChild(2)) {
                this.partnerID = new PartnerID();
                return this.partnerID;
            }
            if (localName.equals("UserID") && parser.allowChild(3)) {
                this.userID = new UserID();
                return this.userID;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(3);
    }
}

