/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.Token;
import de.businesslogics.ebics.schema.types.Parameter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.xml.sax.SAXException;

public class GenericOrderParams
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "GenericOrderParams";
    public static final Token FILENAME = new Token("FILENAME");
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private final ProtocolVersion version;

    public GenericOrderParams() {
        this.version = ProtocolVersion.H002;
    }

    public GenericOrderParams(ProtocolVersion version) {
        this.version = version;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter.Value getParameter(String name) {
        for (Parameter p : this.parameters) {
            if (!name.equals(p.getName().getValue())) continue;
            return p.getValue();
        }
        return null;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (parser.isParentUri(uri) && "Parameter".equals(localName) && parser.allowOrIsChild(0)) {
            Parameter toReturn = new Parameter();
            this.parameters.add(toReturn);
            return toReturn;
        }
        return null;
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        ps.printOut("Parameter", this.parameters);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GenericOrderParams)) {
            return false;
        }
        GenericOrderParams other = (GenericOrderParams)obj;
        return Objects.equals(this.parameters, other.parameters);
    }
}

