/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.XMLDate;
import java.util.Objects;
import org.xml.sax.SAXException;

public class DateRange
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private XMLDate start;
    private XMLDate end;

    public DateRange() {
    }

    public DateRange(XMLDate start, XMLDate end) {
        this.start = start;
        this.end = end;
    }

    public XMLDate getEnd() {
        return this.end;
    }

    public XMLDate getStart() {
        return this.start;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("Start") && parser.allowChild(0)) {
                this.start = new XMLDate();
                return this.start;
            }
            if (localName.equals("End") && parser.allowChild(1)) {
                this.end = new XMLDate();
                return this.end;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.start.printOut("Start", ps);
        this.end.printOut("End", ps);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange)obj;
        return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
    }
}

