/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.HostID;
import de.businesslogics.ebics.schema.types.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.SAXException;

public class BankInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    HostID hostID;
    final List<Parameter> parameters;

    public BankInfo() {
        this.parameters = new ArrayList<Parameter>();
    }

    public BankInfo(HostID hostID, List<Parameter> parameters) {
        this.hostID = hostID;
        this.parameters = Collections.unmodifiableList(parameters);
    }

    public HostID getHostID() {
        return this.hostID;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.hostID.printOut("HostID", ps);
        for (Parameter p : this.parameters) {
            p.printOut("Parameter", ps);
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("HostID") && parser.allowChild(0)) {
                this.hostID = new HostID();
                return this.hostID;
            }
            if (localName.equals("Parameter") && parser.allowOrIsChild(1)) {
                Parameter toReturn = new Parameter();
                this.parameters.add(toReturn);
                return toReturn;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }
}

