/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.DecimalElement;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import org.xml.sax.SAXException;

public class Amount
extends DecimalElement {
    private static final long serialVersionUID = 1L;
    public static final Currency EUR = Currency.getInstance("EUR");
    private Currency currency;

    public Amount() {
    }

    public Amount(BigDecimal value, Currency currency) {
        super(value);
        this.currency = currency;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        String c = attributes.getValueWithDefault("Currency", "EUR");
        try {
            this.currency = Currency.getInstance(c);
        }
        catch (IllegalArgumentException iae) {
            throw new SAXException(iae);
        }
        super.setAttributes(attributes);
    }

    @Override
    public void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("Currency", this.currency.getCurrencyCode(), this.currency.equals(EUR));
    }
}

