/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.AnyElement;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.GenericListElement;
import de.businesslogics.ebics.schema.ListElement;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.h005.UsageOrderType;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.AccountNumber;
import de.businesslogics.ebics.schema.types.BankCode;
import de.businesslogics.ebics.schema.types.NationalAccountNumber;
import de.businesslogics.ebics.schema.types.NationalBankcode;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import org.xml.sax.SAXException;

public class AccountInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    SimpleStringElement accountNumber;
    SimpleStringElement accountNumber2;
    SimpleStringElement bankCode;
    SimpleStringElement bankCode2;
    String currency = "EUR";
    SimpleStringElement accountHolder;
    String description = null;
    EbicsElement usageOrderTypes;
    String ID;

    public AccountInfo() {
    }

    public AccountInfo(SimpleStringElement accountNumber, SimpleStringElement bankCode, String ID) {
        this.accountNumber = accountNumber;
        this.bankCode = bankCode;
        this.ID = ID;
    }

    public String getID() {
        return this.ID;
    }

    public SimpleStringElement getAccountHolder() {
        return this.accountHolder;
    }

    public void setAccountHolder(SimpleStringElement accountHolder) {
        this.accountHolder = accountHolder;
    }

    public SimpleStringElement getAccountNumber2() {
        return this.accountNumber2;
    }

    public void setAccountNumber2(SimpleStringElement accountNumber2) {
        this.accountNumber2 = accountNumber2;
    }

    public SimpleStringElement getBankCode2() {
        return this.bankCode2;
    }

    public void setBankCode2(SimpleStringElement bankCode2) {
        this.bankCode2 = bankCode2;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? "EUR" : currency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EbicsElement getUsageOrderTypes() {
        return this.usageOrderTypes;
    }

    public void setUsageOrderTypes(ListElement<OrderType> usageOrderTypes) {
        this.usageOrderTypes = usageOrderTypes;
    }

    public void setUsageOrderTypes(UsageOrderType usageOrderTypes) {
        this.usageOrderTypes = usageOrderTypes;
    }

    public SimpleStringElement getAccountNumber() {
        return this.accountNumber;
    }

    public SimpleStringElement getBankCode() {
        return this.bankCode;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("ID", this.ID);
        if (!"EUR".equals(this.currency)) {
            ps.addAttribute("Currency", this.currency);
        }
        if (this.description != null) {
            ps.addAttribute("Description", this.description);
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.accountNumber instanceof AccountNumber) {
            this.accountNumber.printOut("AccountNumber", ps);
        } else {
            this.accountNumber.printOut("NationalAccountNumber", ps);
        }
        if (this.accountNumber2 != null) {
            if (this.accountNumber2 instanceof AccountNumber) {
                this.accountNumber2.printOut("AccountNumber", ps);
            } else {
                this.accountNumber2.printOut("NationalAccountNumber", ps);
            }
        }
        if (this.bankCode != null) {
            if (this.bankCode instanceof BankCode) {
                this.bankCode.printOut("BankCode", ps);
            } else {
                this.bankCode.printOut("NationalBankCode", ps);
            }
        }
        if (this.bankCode2 != null) {
            if (this.bankCode2 instanceof BankCode) {
                this.bankCode2.printOut("BankCode", ps);
            } else {
                this.bankCode2.printOut("NationalBankCode", ps);
            }
        }
        if (this.accountHolder != null) {
            this.accountHolder.printOut("AccountHolder", ps);
        }
        ps.printOut("UsageOrderTypes", this.usageOrderTypes);
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        this.ID = attributes.getMandatoryValue("ID");
        this.currency = attributes.getValueWithDefault("Currency", "EUR");
        this.description = attributes.getValue("Description");
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            ProtocolVersion version;
            int lm;
            if (localName.equals("AccountNumber")) {
                if (parser.allowChild(0)) {
                    this.accountNumber = new AccountNumber();
                    return this.accountNumber;
                }
                if (parser.allowChild(1)) {
                    this.accountNumber2 = new AccountNumber();
                    return this.accountNumber2;
                }
            }
            if (localName.equals("NationalAccountNumber")) {
                if (parser.allowChild(0)) {
                    this.accountNumber = new NationalAccountNumber();
                    return this.accountNumber;
                }
                if (parser.allowChild(1)) {
                    this.accountNumber2 = new NationalAccountNumber();
                    return this.accountNumber2;
                }
            }
            if (localName.equals("BankCode")) {
                if (parser.allowChild(0, 2)) {
                    this.bankCode = new BankCode();
                    return this.bankCode;
                }
                if (parser.allowChild(3)) {
                    this.bankCode2 = new BankCode();
                    return this.bankCode2;
                }
            }
            if (localName.equals("NationalBankCode")) {
                if (parser.allowChild(0, 2)) {
                    this.bankCode = new NationalBankcode();
                    return this.bankCode;
                }
                if (parser.allowChild(3)) {
                    this.bankCode2 = new NationalBankcode();
                    return this.bankCode2;
                }
            }
            int n = lm = (version = ProtocolVersion.fromNameSpace(uri)).compareTo(ProtocolVersion.H004) > 0 ? 0 : 2;
            if (localName.equals("AccountHolder") && parser.allowChild(lm, 4)) {
                this.accountHolder = new SimpleStringElement();
                return this.accountHolder;
            }
            if (localName.equals("UsageOrderTypes") && parser.allowChild(lm, 5)) {
                if (version.getVersion() <= 4) {
                    this.usageOrderTypes = new GenericListElement<OrderType>(OrderType.class);
                    return this.usageOrderTypes;
                }
                this.usageOrderTypes = new UsageOrderType();
                return this.usageOrderTypes;
            }
        } else {
            int lm;
            ProtocolVersion version = ProtocolVersion.fromNameSpace(parser.getParentUri());
            int n = lm = version.compareTo(ProtocolVersion.H004) > 0 ? 0 : 2;
            if (parser.allowOrIsChild(lm, 6)) {
                return AnyElement.INSTANCE;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        ProtocolVersion pv = ProtocolVersion.fromNameSpace(parser.getParentUri());
        parser.checkLastMandatory(pv.compareTo(ProtocolVersion.H004) > 0 ? 0 : 2);
    }
}

