/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtresponse;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.ReportText;
import de.businesslogics.ebics.schema.types.ReturnCode;
import java.util.Locale;
import org.xml.sax.SAXException;

public class KeyManagementResponseMutableHeader
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private ReturnCode returnCode;
    private ReportText reportText;
    private OrderID orderID;

    public KeyManagementResponseMutableHeader() {
    }

    public KeyManagementResponseMutableHeader(Locale locale, ReturnCode returnCode) {
        this.returnCode = returnCode;
        this.reportText = ReportText.getReportFor(locale, returnCode);
    }

    public ReportText getReportText() {
        return this.reportText;
    }

    public ReturnCode getReturnCode() {
        return this.returnCode;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.printOut("OrderID", this.orderID);
        this.returnCode.printOut("ReturnCode", ps);
        this.reportText.printOut("ReportText", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("OrderID") && ProtocolVersion.fromNameSpace(uri).getVersion() >= 4 && parser.allowChild(0)) {
                this.orderID = new OrderID();
                return this.orderID;
            }
            if (localName.equals("ReturnCode") && parser.allowChild(-1, 1)) {
                this.returnCode = new ReturnCode(ProtocolVersion.fromNameSpace(uri));
                return this.returnCode;
            }
            if (localName.equals("ReportText") && parser.allowChild(2)) {
                this.reportText = new ReportText();
                return this.reportText;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    public OrderID getOrderID() {
        return this.orderID;
    }

    public void setOrderID(OrderID orderID) {
        this.orderID = orderID;
    }
}

