/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtresponse;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.DataEncryption;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyDigest;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.SecretKey;
import org.xml.sax.SAXException;

public class KeyManagementResponseDataTransfer
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    DataEncryption dataEncryption;
    Base64Element orderData;

    public KeyManagementResponseDataTransfer() {
    }

    public KeyManagementResponseDataTransfer(byte[] rawData) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream gos = new DeflaterOutputStream(bos);
            gos.write(rawData);
            gos.close();
            this.orderData = new Base64Element(bos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.dataEncryption = null;
    }

    public void encrypt(RSAPublicKey pubKey, byte[] keyDigest, EncryptionHandler handler) {
        try {
            if (this.dataEncryption != null) {
                return;
            }
            if (keyDigest == null) {
                keyDigest = handler.getHash(pubKey);
            }
            SecretKey key = handler.createSecretKey();
            EncryptionPubKeyDigest pubKeyDigest = handler.createPubKeyDigest(keyDigest);
            Base64Element transactionKey = new Base64Element(handler.encrypt(pubKey, key));
            this.dataEncryption = new DataEncryption(pubKeyDigest, transactionKey);
            if (this.orderData != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(this.orderData.getValue().length + 32);
                OutputStream os = handler.encryptContent(key, bos);
                os.write(this.orderData.getValue());
                os.close();
                this.orderData = new Base64Element(bos.toByteArray());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void decrypt(EncryptionHandler handler, SecretKey key) throws SAXException {
        try {
            if (this.orderData != null) {
                ByteArrayInputStream src = new ByteArrayInputStream(this.orderData.getValue());
                this.orderData = new Base64Element(Streams.readAll(handler.decryptContent(key, src)));
            }
            this.dataEncryption = null;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.dataEncryption != null) {
            this.dataEncryption.printOut("DataEncryptionInfo", ps);
        }
        if (this.orderData != null) {
            this.orderData.printOut("OrderData", ps);
        }
    }

    @Override
    public EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if ("DataEncryptionInfo".equals(localName) && parser.allowChild(0)) {
                this.dataEncryption = new DataEncryption();
                return this.dataEncryption;
            }
            if ("OrderData".equals(localName) && parser.allowChild(1)) {
                this.orderData = new Base64Element();
                return this.orderData;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    public DataEncryption getDataEncryption() throws SAXException {
        if (this.dataEncryption == null) {
            throw new SAXException("Not encrypted");
        }
        return this.dataEncryption;
    }

    public InputStream getOrderData() throws SAXException {
        if (this.orderData == null) {
            throw new SAXException("Element missing");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(this.orderData.getValue());
        return new InflaterInputStream(bis);
    }
}

