/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtresponse;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.keymgmtresponse.KeyManagementResponseDataTransfer;
import de.businesslogics.ebics.schema.response.AuthenticatedTimeStamp;
import de.businesslogics.ebics.schema.types.AuthenticatedReturnCode;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import org.xml.sax.SAXException;

public class KeyManagementResponseBody
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private KeyManagementResponseDataTransfer dataTransfer;
    private AuthenticatedReturnCode returnCode;
    private AuthenticatedTimeStamp timestampBankParameter;

    @Deprecated
    public KeyManagementResponseBody() {
    }

    public KeyManagementResponseBody(AuthenticatedReturnCode returnCode) {
        this.returnCode = returnCode;
    }

    public KeyManagementResponseDataTransfer getDataTransfer() {
        return this.dataTransfer;
    }

    public AuthenticatedTimeStamp getTimestampBankParameter() {
        return this.timestampBankParameter;
    }

    public void setTimestampBankParameter(AuthenticatedTimeStamp timestampBankParameter) {
        this.timestampBankParameter = timestampBankParameter;
    }

    public void setDataTransfer(KeyManagementResponseDataTransfer dataTransfer) {
        this.dataTransfer = dataTransfer;
    }

    public AuthenticatedReturnCode getReturnCode() {
        return this.returnCode;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.dataTransfer != null) {
            this.dataTransfer.printOut("DataTransfer", ps);
        }
        this.returnCode.printOut("ReturnCode", ps);
        if (this.timestampBankParameter != null) {
            this.timestampBankParameter.printOut("TimestampBankParameter", ps);
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if ("DataTransfer".equals(localName) && parser.allowChild(0)) {
                this.dataTransfer = new KeyManagementResponseDataTransfer();
                return this.dataTransfer;
            }
            if ("ReturnCode".equals(localName) && parser.allowChild(-1, 1)) {
                this.returnCode = new AuthenticatedReturnCode(ProtocolVersion.fromNameSpace(uri));
                return this.returnCode;
            }
            if ("TimestampBankParameter".equals(localName) && parser.allowChild(2)) {
                this.timestampBankParameter = new AuthenticatedTimeStamp();
                return this.timestampBankParameter;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }
}

