/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtresponse;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.keymgmtresponse.KeyManagementResponseBody;
import de.businesslogics.ebics.schema.keymgmtresponse.KeyManagementResponseHeader;
import de.businesslogics.ebics.schema.keymgmtresponse.KeyManagementResponseMutableHeader;
import de.businesslogics.ebics.schema.response.AuthenticatedTimeStamp;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.MinimalEbicsResponse;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.io.File;
import org.xml.sax.SAXException;

public class EbicsKeyManagementResponse
extends MinimalEbicsResponse {
    private static final long serialVersionUID = 1L;
    private static final String[] SCHEMA_LOCATIONS = new String[]{ProtocolVersion.H002.getNamespace() + " http://www.ebics.org/H002/ebics_keymgmt_response.xsd", ProtocolVersion.H003.getNamespace() + " http://www.ebics.org/H003/ebics_keymgmt_response.xsd", ProtocolVersion.H004.getNamespace() + " http://www.ebics.org/H004/ebics_keymgmt_response_H004.xsd"};
    private ProtocolVersion version;
    private int revision;
    private KeyManagementResponseHeader header;
    private KeyManagementResponseBody body;
    public File logFile;

    public EbicsKeyManagementResponse(ProtocolVersion version) {
        this.version = version;
    }

    public EbicsKeyManagementResponse(ProtocolVersion version, KeyManagementResponseHeader header, KeyManagementResponseBody body) {
        this.version = version;
        this.revision = 1;
        this.header = header;
        this.body = body;
    }

    @Override
    public String name() {
        return "ebicsKeyManagementResponse";
    }

    public KeyManagementResponseBody getBody() {
        return this.body;
    }

    public KeyManagementResponseHeader getHeader() {
        return this.header;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public int getRevision() {
        return this.revision;
    }

    public void checkOK() throws EbicsException {
        KeyManagementResponseMutableHeader m = this.header.getMutable();
        m.getReturnCode().throwException(m.getReportText());
        this.body.getReturnCode().throwException();
    }

    @Override
    public AuthenticatedTimeStamp getTimestampBankParameters() {
        return this.body.getTimestampBankParameter();
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        if (SCHEMA_LOCATIONS.length > this.version.getVersion() - 2) {
            ps.addAttribute("xsi:schemaLocation", SCHEMA_LOCATIONS[this.version.getVersion() - 2]);
        }
        ps.addAttribute("Version", this.version.getValue());
        ps.addAttribute("Revision", Integer.toString(this.revision));
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.header.printOut("header", ps);
        this.body.printOut("body", ps);
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
        if (SCHEMA_LOCATIONS.length > this.version.getVersion() - 2) {
            ps.addNamespaceDecl("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("header") && parser.allowChild(0)) {
                this.header = new KeyManagementResponseHeader();
                return this.header;
            }
            if (localName.equals("body") && parser.allowChild(1)) {
                this.body = new KeyManagementResponseBody();
                return this.body;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("Version", this.version.getValue());
        this.revision = attributes.getInt("Revision", 1);
        if (this.revision < 1 || this.revision > 99) {
            throw new SAXException("Ebics revision=" + this.revision + " out of range");
        }
    }

    public static ElementParser createParser(ProtocolVersion version) {
        EbicsKeyManagementResponse response = new EbicsKeyManagementResponse(version);
        response.version = version;
        return new EbicsRootParser(version.getNamespace(), response);
    }
}

