/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtrequest;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.UserSignatureData;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.xml.sax.SAXException;

public class UnsignedRequestDataTransfer
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    SignatureData signatureData;
    Base64Element orderData;

    @Deprecated
    public UnsignedRequestDataTransfer() {
    }

    public UnsignedRequestDataTransfer(UserSignatureData signature, byte[] hsaBytes) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream gos = new DeflaterOutputStream(bos);
            EbicsPrintStream eps = new EbicsPrintStream(gos);
            eps.printOut(signature);
            this.signatureData = new SignatureData(bos.toByteArray());
            bos.reset();
            gos = new DeflaterOutputStream(bos);
            gos.write(hsaBytes);
            gos.close();
            this.orderData = new Base64Element(bos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public UserSignatureData getSignatureData(ProtocolVersion protocolVersion) throws IOException, SAXException {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.signatureData.getValue());
        InflaterInputStream is = new InflaterInputStream(bis);
        return (UserSignatureData)EbicsHandler.parse(is, UserSignatureData.createParser(protocolVersion), UserSignatureData.getNamespaceSchemaLocation(protocolVersion));
    }

    public InputStream getOrderData() throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.orderData.getValue());
        return new InflaterInputStream(bis);
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.signatureData.printOut("SignatureData", ps);
        this.orderData.printOut("OrderData", ps);
    }

    @Override
    public EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("SignatureData") && parser.allowChild(0)) {
                this.signatureData = new SignatureData();
                return this.signatureData;
            }
            if ("OrderData".equals(localName) && parser.allowChild(1)) {
                this.orderData = new Base64Element();
                return this.orderData;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }
}

