/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtrequest;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.HIARequestOrderData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.xml.sax.SAXException;

public class UnsecuredRequestDataTransfer
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    Base64Element orderData;

    public UnsecuredRequestDataTransfer() {
    }

    public UnsecuredRequestDataTransfer(byte[] orderData) {
        this.setOrderData(orderData);
    }

    public UnsecuredRequestDataTransfer(HIARequestOrderData hia) {
        this.setOrderData(EbicsPrintStream.toByteArray(hia));
    }

    public InputStream getOrderData() {
        return new InflaterInputStream(new ByteArrayInputStream(this.orderData.getValue()));
    }

    private void setOrderData(byte[] orderData) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream gos = new DeflaterOutputStream(bos);
            gos.write(orderData);
            gos.close();
            this.orderData = new Base64Element(bos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.orderData != null) {
            this.orderData.printOut("OrderData", ps);
        }
    }

    @Override
    public EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri) && "OrderData".equals(localName) && parser.allowChild(0)) {
            this.orderData = new Base64Element();
            return this.orderData;
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }
}

