/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtrequest;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.request.OrderAttribute;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import org.xml.sax.SAXParseException;

public class OrderDetails
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private OrderType orderType;
    private OrderID orderID;
    private OrderAttribute orderAttribute;

    @Deprecated
    public OrderDetails() {
    }

    public OrderDetails(OrderType orderType, OrderID orderID, OrderAttribute orderAttribute) {
        this.orderType = orderType;
        this.orderID = orderID;
        this.orderAttribute = orderAttribute;
    }

    public OrderAttribute getOrderAttribute() {
        return this.orderAttribute;
    }

    public OrderID getOrderID() {
        return this.orderID;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        short version = ProtocolVersion.fromNameSpace(ps.getNamespaceURI("")).getVersion();
        this.orderType.printOut(version < 5 ? "OrderType" : "AdminOrderType", ps);
        ps.printOut("OrderID", this.orderID);
        ps.printOut("OrderAttribute", this.orderAttribute);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) {
        if (parser.isParentUri(uri)) {
            short version = ProtocolVersion.fromNameSpace(uri).getVersion();
            if (version < 5) {
                if ("OrderType".equals(localName) && parser.allowChild(0)) {
                    this.orderType = new OrderType();
                    return this.orderType;
                }
            } else if ("AdminOrderType".equals(localName) && parser.allowChild(0)) {
                this.orderType = new OrderType();
                return this.orderType;
            }
            if (version < 4 && "OrderID".equals(localName) && parser.allowChild(1)) {
                this.orderID = new OrderID();
                return this.orderID;
            }
            if (version < 5 && "OrderAttribute".equals(localName) && parser.allowChild(0, 2)) {
                this.orderAttribute = new OrderAttribute();
                return this.orderAttribute;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXParseException {
        short version = ProtocolVersion.fromNameSpace(parser.getParentUri()).getVersion();
        parser.checkLastMandatory(version < 5 ? 2 : 0);
    }
}

