/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtrequest;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.keymgmtrequest.EbicsKeyManagementRequest;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsecuredRequestBody;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsecuredRequestHeader;
import de.businesslogics.ebics.schema.request.Product;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import org.xml.sax.SAXException;

public class EbicsUnsecuredRequest
extends EbicsRootElement
implements EbicsKeyManagementRequest {
    private static final long serialVersionUID = 1L;
    private final ProtocolVersion version;
    private int revision;
    private UnsecuredRequestHeader header;
    private UnsecuredRequestBody body;

    private EbicsUnsecuredRequest(ProtocolVersion version) {
        this.version = version;
    }

    public EbicsUnsecuredRequest(ProtocolVersion version, UnsecuredRequestHeader header, UnsecuredRequestBody body) {
        this.version = version;
        this.header = header;
        this.body = body;
    }

    public int getRevision() {
        return this.revision;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public UnsecuredRequestHeader getHeader() {
        return this.header;
    }

    public UnsecuredRequestBody getBody() {
        return this.body;
    }

    @Override
    public Product getProduct() {
        return this.header.getStatic().getProduct();
    }

    @Override
    public String name() {
        return "ebicsUnsecuredRequest";
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("Version", this.version.getValue());
        ps.addAttribute("Revision", "1");
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.header.printOut("header", ps);
        this.body.printOut("body", ps);
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
        ps.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("header") && parser.allowChild(0)) {
                return new UnsecuredRequestHeader();
            }
            if (localName.equals("body") && parser.allowChild(1)) {
                return new UnsecuredRequestBody();
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    @Override
    protected void endChild(ElementParser parser, EbicsElement element) {
        switch (parser.getCurrentChild()) {
            case 0: {
                this.header = (UnsecuredRequestHeader)element;
                break;
            }
            case 1: {
                this.body = (UnsecuredRequestBody)element;
            }
        }
    }

    @Override
    public void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("Version", this.version.getValue());
        this.revision = attributes.getInt("Revision", 1);
        if (this.revision < 1 || this.revision > 99) {
            throw new SAXException("Ebics revision=" + this.revision + " out of range");
        }
    }

    public static ElementParser createParser(ProtocolVersion version) {
        return new EbicsUnsecuredRequest(version).createParser();
    }
}

