/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.keymgmtrequest;

import de.businesslogics.ebics.schema.AuthenticableRootElement;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.EmptyElement;
import de.businesslogics.ebics.schema.keymgmtrequest.EbicsKeyManagementRequest;
import de.businesslogics.ebics.schema.keymgmtrequest.NoPubKeyDigestsRequestHeader;
import de.businesslogics.ebics.schema.request.Product;
import de.businesslogics.ebics.schema.signature.Signature;
import de.businesslogics.ebics.schema.types.Nonce;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.TimeStamp;
import org.xml.sax.SAXException;

public class EbicsNoPubKeyDigestsRequest
extends EbicsRootElement
implements EbicsKeyManagementRequest,
AuthenticableRootElement {
    private static final long serialVersionUID = 1L;
    private final ProtocolVersion version;
    private int revision;
    private NoPubKeyDigestsRequestHeader header;
    private Signature authSignature;

    private EbicsNoPubKeyDigestsRequest(ProtocolVersion version) {
        this.version = version;
    }

    public EbicsNoPubKeyDigestsRequest(ProtocolVersion version, NoPubKeyDigestsRequestHeader header) {
        this.version = version;
        this.header = header;
    }

    public int getRevision() {
        return this.revision;
    }

    @Override
    public ProtocolVersion getVersion() {
        return this.version;
    }

    public NoPubKeyDigestsRequestHeader getHeader() {
        return this.header;
    }

    @Override
    public Signature getAuthSignature() {
        return this.authSignature;
    }

    @Override
    public void setAuthSignature(Signature authSignature) {
        this.authSignature = authSignature;
    }

    @Override
    public Nonce getNonce() {
        return this.header.getStatic().getNonce();
    }

    @Override
    public TimeStamp getTimestamp() {
        return this.header.getStatic().getTimestamp();
    }

    @Override
    public Product getProduct() {
        return this.header.getStatic().getProduct();
    }

    @Override
    public String name() {
        return "ebicsNoPubKeyDigestsRequest";
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("Version", this.version.getValue());
        ps.addAttribute("Revision", "1");
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.header.printOut("header", ps);
        if (this.authSignature != null) {
            this.authSignature.printOut("AuthSignature", ps);
        }
        EmptyElement.INSTANCE.printOut("body", ps);
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
        ps.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("header") && parser.allowChild(0)) {
                this.header = new NoPubKeyDigestsRequestHeader();
                return this.header;
            }
            if (localName.equals("AuthSignature") && parser.allowChild(1)) {
                this.authSignature = new Signature();
                return this.authSignature;
            }
            if (localName.equals("body") && parser.allowChild(2)) {
                return EmptyElement.INSTANCE;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    @Override
    protected void endChild(ElementParser parser, EbicsElement element) {
        switch (parser.getCurrentChild()) {
            case 0: {
                this.header = (NoPubKeyDigestsRequestHeader)element;
                break;
            }
            case 1: {
                this.authSignature = (Signature)element;
            }
        }
    }

    @Override
    public void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("Version", this.version.getValue());
        this.revision = attributes.getInt("Revision", 1);
        if (this.revision < 1 || this.revision > 99) {
            throw new SAXException("Ebics revision=" + this.revision + " out of range");
        }
    }

    public static ElementParser createParser(ProtocolVersion version) {
        return new EbicsNoPubKeyDigestsRequest(version).createParser();
    }
}

