/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.h005;

import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h005.CodeStringType;
import java.util.HashSet;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ContainerStringType
extends CodeStringType {
    private static final long serialVersionUID = 1L;
    private static final HashSet<String> ALLOWED_VALUES = new HashSet(3);

    public ContainerStringType(String value) {
        super(value);
    }

    public ContainerStringType() {
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        super.endElement(parser);
        if (this.value.length() < 3) {
            throw new SAXParseException("Min length of 3 undershoot.", parser.getLocator());
        }
        if (this.value.length() > 3) {
            throw new SAXParseException("Max length of 3 exeeded.", parser.getLocator());
        }
        if (!ALLOWED_VALUES.contains(this.value)) {
            throw new SAXParseException("Value '" + this.value + "' not allowed", parser.getLocator());
        }
    }

    static {
        ALLOWED_VALUES.add("SVC");
        ALLOWED_VALUES.add("XML");
        ALLOWED_VALUES.add("ZIP");
    }
}

