/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.h005;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h005.BTFParamsTyp;
import de.businesslogics.ebics.schema.h005.Parameter;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.orders.DateRange;
import de.businesslogics.util.Objects;
import org.xml.sax.SAXException;

public class BTDParamsType
extends BTFParamsTyp {
    private static final long serialVersionUID = 1L;

    public BTDParamsType(RestrictedServiceType service) {
        super(service);
    }

    @Deprecated
    public BTDParamsType() {
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (parser.isParentUri(uri)) {
            if ("Service".equals(localName) && parser.allowChild(0)) {
                this.service = new RestrictedServiceType();
                return this.service;
            }
            if ("DateRange".equals(localName) && parser.allowChild(1)) {
                this.dateRange = new DateRange();
                return this.dateRange;
            }
            if ("Parameter".equals(localName) && parser.allowOrIsChild(0, 2)) {
                Parameter toReturn = new Parameter();
                this.parameters.add(toReturn);
                return toReturn;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }

    public int hashCode() {
        int toReturn = this.getFileName() != null ? this.getFileName().hashCode() : 0;
        toReturn = toReturn * 31 + (this.getService() != null ? this.getService().hashCode() : 0);
        toReturn = toReturn * 31 + (this.getSignatureFlag() != null ? this.getSignatureFlag().hashCode() : 0);
        toReturn = toReturn * 31 + (this.getDateRange() != null ? this.getDateRange().hashCode() : 0);
        int paramsHashCode = 1;
        for (Parameter parameter : this.getParameters()) {
            int paramHashCode = 1;
            paramHashCode = 31 * paramHashCode + (parameter.getName() == null ? 0 : parameter.getName().hashCode());
            paramHashCode = 31 * paramHashCode + (parameter.getValue() == null ? 0 : parameter.getValue().hashCode());
            paramsHashCode = 31 * paramsHashCode + paramHashCode;
        }
        toReturn = toReturn * 31 + paramsHashCode;
        return toReturn;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BTDParamsType)) {
            return false;
        }
        BTDParamsType other = (BTDParamsType)obj;
        if (this.getParameters().size() != other.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Parameter p1 = this.getParameters().get(i);
            Parameter p2 = other.getParameters().get(i);
            if (Objects.equals(p1.getName(), p2.getName()) && Objects.equals(p1.getValue(), p2.getValue())) continue;
            return false;
        }
        return Objects.equals(this.getFileName(), other.getFileName()) && Objects.equals(this.getService(), other.getService()) && Objects.equals(this.getSignatureFlag(), other.getSignatureFlag()) && Objects.equals(this.getDateRange(), other.getDateRange());
    }
}

