/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.h003;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.UserSignatureData;
import de.businesslogics.ebics.schema.s001.SignaturePubKeyInfoType;
import de.businesslogics.ebics.schema.types.AuthenticationPubKeyInfo;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyInfo;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.UserID;
import org.xml.sax.SAXException;

public class HCSRequestOrderData
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    private AuthenticationPubKeyInfo authenticationPubKeyInfo;
    private EncryptionPubKeyInfo encryptionPubKeyInfo;
    private SignaturePubKeyInfoType signaturePubKeyInfo;
    private PartnerID partnerID;
    private UserID userID;
    private final ProtocolVersion version;

    public HCSRequestOrderData(ProtocolVersion version) {
        this.version = version;
    }

    public HCSRequestOrderData(ProtocolVersion version, AuthenticationPubKeyInfo authenticationPubKeyInfo, EncryptionPubKeyInfo encryptionPubKeyInfo, SignaturePubKeyInfoType signaturePubKeyInfo, PartnerID partnerID, UserID userID) {
        this.version = version;
        this.authenticationPubKeyInfo = authenticationPubKeyInfo;
        this.encryptionPubKeyInfo = encryptionPubKeyInfo;
        this.signaturePubKeyInfo = signaturePubKeyInfo;
        this.partnerID = partnerID;
        this.userID = userID;
    }

    public AuthenticationPubKeyInfo getAuthenticationPubKeyInfo() {
        return this.authenticationPubKeyInfo;
    }

    public EncryptionPubKeyInfo getEncryptionPubKeyInfo() {
        return this.encryptionPubKeyInfo;
    }

    public SignaturePubKeyInfoType getSignaturePubKeyInfo() {
        return this.signaturePubKeyInfo;
    }

    public PartnerID getPartnerID() {
        return this.partnerID;
    }

    public UserID getUserID() {
        return this.userID;
    }

    @Override
    public String name() {
        return "HCSRequestOrderData";
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.authenticationPubKeyInfo.printOut("AuthenticationPubKeyInfo", ps);
        this.encryptionPubKeyInfo.printOut("EncryptionPubKeyInfo", ps);
        this.signaturePubKeyInfo.printOut("esig:SignaturePubKeyInfo", ps);
        this.partnerID.printOut("PartnerID", ps);
        this.userID.printOut("UserID", ps);
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
        ps.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
        ps.addNamespaceDecl("esig", UserSignatureData.getSignatureUri(this.version));
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("AuthenticationPubKeyInfo") && parser.allowChild(0)) {
                this.authenticationPubKeyInfo = new AuthenticationPubKeyInfo();
                return this.authenticationPubKeyInfo;
            }
            if (localName.equals("EncryptionPubKeyInfo") && parser.allowChild(1)) {
                this.encryptionPubKeyInfo = new EncryptionPubKeyInfo();
                return this.encryptionPubKeyInfo;
            }
            if (localName.equals("PartnerID") && parser.allowChild(3)) {
                this.partnerID = new PartnerID();
                return this.partnerID;
            }
            if (localName.equals("UserID") && parser.allowChild(4)) {
                this.userID = new UserID();
                return this.userID;
            }
        } else if (uri.equals(UserSignatureData.getSignatureUri(this.version)) && localName.equals("SignaturePubKeyInfo") && parser.allowChild(2)) {
            this.signaturePubKeyInfo = new SignaturePubKeyInfoType();
            return this.signaturePubKeyInfo;
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(4);
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }
}

