/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.h003;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.h003.CountryCode;
import de.businesslogics.util.Objects;
import org.xml.sax.SAXException;

public class FileFormat
extends SimpleStringElement {
    private static final long serialVersionUID = 1L;
    private CountryCode countryCode;

    @Deprecated
    public FileFormat() {
    }

    public FileFormat(String s) {
        super(s);
    }

    public CountryCode getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(CountryCode countryCode) {
        this.countryCode = countryCode;
    }

    @Override
    public void addAttributes(EbicsPrintStream ps) {
        if (this.countryCode != null) {
            ps.addAttribute("CountryCode", this.countryCode.getValue());
        }
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        String s = attributes.getValue("CountryCode");
        if (s != null) {
            if (!CountryCode.Parser.PATTERN.matcher(s).matches()) {
                throw new SAXException("Illegal country code: " + s);
            }
            this.countryCode = new CountryCode(s);
        }
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        this.value = ((SimpleStringElement.Parser)parser).getCondensed();
    }

    public String getFullOrderType(String orderType) {
        StringBuilder sb = new StringBuilder(orderType);
        if (this.countryCode != null) {
            sb.append('.');
            sb.append(this.countryCode.getValue());
        }
        sb.append('.');
        sb.append(this.getValue());
        return sb.toString();
    }

    public static FileFormat fromFullOrderType(String orderType) {
        if (orderType.length() < 5) {
            return null;
        }
        int i = orderType.indexOf(46, 4);
        if (i == 6 && Character.isUpperCase(orderType.charAt(4)) && Character.isUpperCase(orderType.charAt(5))) {
            FileFormat toReturn = new FileFormat(orderType.substring(7));
            toReturn.setCountryCode(new CountryCode(orderType.substring(4, 6)));
            return toReturn;
        }
        return new FileFormat(orderType.substring(4));
    }

    @Override
    public int hashCode() {
        int toReturn = super.hashCode() * 31;
        if (this.countryCode != null) {
            toReturn += this.countryCode.hashCode();
        }
        return toReturn;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileFormat) || !super.equals(obj)) {
            return false;
        }
        FileFormat oth = (FileFormat)obj;
        return Objects.equals(this.countryCode, oth.countryCode);
    }
}

