/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.h003;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.types.Parameter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class FULOrderParams
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "FULOrderParams";
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private FileFormat fileFormat;
    private ProtocolVersion version;

    public FULOrderParams() {
        this.version = null;
    }

    public FULOrderParams(FileFormat fileFormat) {
        this.version = ProtocolVersion.H003;
        this.fileFormat = fileFormat;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter.Value getParameter(String name) {
        for (Parameter p : this.parameters) {
            if (!name.equals(p.getName().getValue())) continue;
            return p.getValue();
        }
        return Parameter.Value.EMPTY;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (this.version == null) {
                this.version = ProtocolVersion.fromNameSpace(uri);
            }
            if ("Parameter".equals(localName) && parser.allowOrIsChild(0)) {
                Parameter toReturn = new Parameter();
                this.parameters.add(toReturn);
                return toReturn;
            }
            if ("FileFormat".equals(localName) && parser.allowChild(-1, 1)) {
                this.fileFormat = new FileFormat();
                return this.fileFormat;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        ps.printOut("Parameter", this.parameters);
        this.fileFormat.printOut("FileFormat", ps);
    }
}

