/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.h003;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.orders.DateRange;
import de.businesslogics.ebics.schema.types.Parameter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.xml.sax.SAXException;

public class FDLOrderParams
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "FDLOrderParams";
    private DateRange dateRange;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private FileFormat fileFormat;
    private ProtocolVersion version;

    public FDLOrderParams() {
        this.version = null;
    }

    public FDLOrderParams(FileFormat fileFormat) {
        this.version = ProtocolVersion.H003;
        this.fileFormat = fileFormat;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter.Value getParameter(String name) {
        for (Parameter p : this.parameters) {
            if (!name.equals(p.getName().getValue())) continue;
            return p.getValue();
        }
        return Parameter.Value.EMPTY;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (this.version == null) {
                this.version = ProtocolVersion.fromNameSpace(uri);
            }
            if ("DateRange".equals(localName) && parser.allowChild(0)) {
                this.dateRange = new DateRange();
                return this.dateRange;
            }
            if ("Parameter".equals(localName) && parser.allowOrIsChild(-1, 1)) {
                Parameter toReturn = new Parameter();
                this.parameters.add(toReturn);
                return toReturn;
            }
            if ("FileFormat".equals(localName) && parser.allowChild(-1, 2)) {
                this.fileFormat = new FileFormat();
                return this.fileFormat;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        ps.printOut("DateRange", this.dateRange);
        ps.printOut("Parameter", this.parameters);
        this.fileFormat.printOut("FileFormat", ps);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    protected void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateRange == null ? 0 : this.dateRange.hashCode());
        result = 31 * result + (this.fileFormat == null ? 0 : this.fileFormat.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FDLOrderParams)) {
            return false;
        }
        FDLOrderParams other = (FDLOrderParams)obj;
        return Objects.equals(this.dateRange, other.dateRange) && Objects.equals(this.fileFormat, other.fileFormat) && Objects.equals(this.parameters, other.parameters);
    }
}

