/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.h000;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.h000.SystemReturnCode;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class EbicsHEVResponse
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    private SystemReturnCode systemReturnCode;
    private final List<VersionNumber> versionNumbers;

    public EbicsHEVResponse() {
        this.versionNumbers = new ArrayList<VersionNumber>();
    }

    public EbicsHEVResponse(SystemReturnCode systemReturnCode, List<VersionNumber> versionNumbers) {
        this.systemReturnCode = systemReturnCode;
        this.versionNumbers = versionNumbers;
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", "http://www.ebics.org/H000");
    }

    @Override
    public String name() {
        return "ebicsHEVResponse";
    }

    public SystemReturnCode getSystemReturnCode() {
        return this.systemReturnCode;
    }

    public List<VersionNumber> getVersionNumbers() {
        return this.versionNumbers;
    }

    public boolean canH003() {
        return this.can(ProtocolVersion.H003);
    }

    public boolean canH004() {
        return this.can(ProtocolVersion.H004);
    }

    public boolean canH005() {
        return this.can(ProtocolVersion.H005);
    }

    public boolean can(ProtocolVersion pv) {
        String pvs = pv.getValue();
        for (VersionNumber vn : this.versionNumbers) {
            if (!vn.getProtocolVersion().equals(pvs)) continue;
            return true;
        }
        return false;
    }

    public ProtocolVersion getMaxVersion() {
        String toReturn = "H002";
        for (VersionNumber vn : this.versionNumbers) {
            if (vn.getProtocolVersion().compareTo(toReturn) <= 0) continue;
            toReturn = vn.getProtocolVersion();
        }
        return ProtocolVersion.getInstance(toReturn);
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.systemReturnCode.printOut("SystemReturnCode", ps);
        ps.printOut("VersionNumber", this.versionNumbers);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if ("http://www.ebics.org/H000".equals(uri)) {
            if (localName.equals("SystemReturnCode") && parser.allowChild(0)) {
                this.systemReturnCode = new SystemReturnCode();
                return this.systemReturnCode;
            }
            if (localName.equals("VersionNumber") && (parser.getCurrentChild() == 1 || parser.allowChild(1))) {
                VersionNumber vn = new VersionNumber();
                this.versionNumbers.add(vn);
                return vn;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }

    public static class VersionNumber
    extends SimpleStringElement {
        private static final long serialVersionUID = 1L;
        private static final Pattern VERSION_NUMBER_PATTERN = Pattern.compile("[0-9]{2}[.][0-9]{2}");
        private static final Pattern PROTOCOL_VERSION_PATTERN = Pattern.compile("H\\d{3}");
        private String protocolVersion;

        VersionNumber() {
        }

        public VersionNumber(String version, String protocolVersion) {
            super(version);
            this.protocolVersion = protocolVersion;
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            ps.addAttribute("ProtocolVersion", this.protocolVersion);
        }

        @Override
        protected void endElement(ElementParser parser) throws SAXException {
            this.value = ((SimpleStringElement.Parser)parser).getCondensed();
            parser.checkPattern(this.value, VERSION_NUMBER_PATTERN);
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.protocolVersion = attributes.getMandatoryValue("ProtocolVersion");
            if (!PROTOCOL_VERSION_PATTERN.matcher(this.protocolVersion).matches()) {
                throw new SAXException("Illegal protocol version: " + this.protocolVersion);
            }
        }
    }
}

