/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.SAXException;

public abstract class XMLEnumeration<T extends XMLEnumeration<T>>
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    protected String value;

    public XMLEnumeration(String value) {
        this.value = value;
        this.getValues().put(value, this);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public final void printValue(EbicsPrintStream ps) {
        ps.print(this.value);
    }

    public String toString() {
        return this.value;
    }

    protected Object readResolve() {
        T toReturn = this.getValues().get(this.getValue());
        return toReturn != null ? toReturn : this;
    }

    @Override
    public Parser<T> createParser() {
        return new Parser<T>(this.getValues());
    }

    public T getInstance(String s) throws SAXException {
        Map<String, T> values = this.getValues();
        XMLEnumeration toReturn = (XMLEnumeration)values.get(s);
        if (toReturn == null) {
            Iterator<T> i = values.values().iterator();
            throw new SAXException("Value '" + s + "' not allowed for " + ((XMLEnumeration)i.next()).getClass().getName());
        }
        return (T)toReturn;
    }

    protected abstract Map<String, T> getValues();

    protected static class Parser<T extends XMLEnumeration<T>>
    extends SimpleStringElement.Parser {
        private final Map<String, T> values;

        protected Parser(Map<String, T> values) {
            this.values = values;
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            String value = this.getCondensed();
            XMLEnumeration toReturn = (XMLEnumeration)this.values.get(value);
            if (toReturn == null) {
                Iterator<T> i = this.values.values().iterator();
                throw new SAXException("Value '" + value + "' not allowed for " + ((XMLEnumeration)i.next()).getClass().getName());
            }
            return toReturn;
        }
    }
}

