/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleStringElement
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    protected String value;

    public SimpleStringElement() {
    }

    public SimpleStringElement(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static String getNonNullValue(SimpleStringElement e) {
        if (e != null) {
            return e.getValue();
        }
        return "";
    }

    public static String getValue(SimpleStringElement e) {
        if (e == null) {
            return null;
        }
        return e.value;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.print(this.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public ElementParser createParser() {
        return new StringParser(this);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleStringElement)) {
            return false;
        }
        return ((SimpleStringElement)obj).value.equals(this.value);
    }

    public boolean valueEquals(SimpleStringElement se) {
        return se != null && this.value.equals(se.value);
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        this.value = ((StringParser)parser).sb.toString();
    }

    public static class StringParser
    extends Parser {
        private final EbicsElement toReturn;

        public StringParser(EbicsElement toReturn) {
            this.toReturn = toReturn;
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.toReturn.setAttributes(attributes);
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.toReturn.endElement(this);
            return this.toReturn;
        }
    }

    public static class Parser
    extends ElementParser {
        protected StringBuilder sb = new StringBuilder();

        protected Parser() {
            super(0);
        }

        @Override
        protected void characters(char[] content, int offset, int length) {
            this.sb.append(content, offset, length);
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            return new SimpleStringElement(this.sb.toString());
        }

        private void replace() {
            for (int i = 0; i < this.sb.length(); ++i) {
                char c = this.sb.charAt(i);
                if (c != '\t' && c != '\n' && c != '\r') continue;
                this.sb.setCharAt(i, ' ');
            }
        }

        public String getReplaced() {
            this.replace();
            return this.sb.toString();
        }

        public String getCondensed() {
            this.replace();
            int wpos = 0;
            int rpos = 0;
            char c = '#';
            block0: while (rpos < this.sb.length()) {
                while (rpos < this.sb.length() && this.sb.charAt(rpos) == ' ') {
                    ++rpos;
                }
                while (rpos < this.sb.length()) {
                    c = this.sb.charAt(rpos);
                    this.sb.setCharAt(wpos++, c);
                    ++rpos;
                    if (c != 32) continue;
                    continue block0;
                }
            }
            this.sb.setLength(c == ' ' ? wpos - 1 : wpos);
            return this.sb.toString();
        }

        public void checkLength(int minLength, int maxLength) throws SAXParseException {
            if (this.sb.length() < minLength) {
                throw new SAXParseException("Length must be at least " + minLength, this.locator);
            }
            if (this.sb.length() > maxLength) {
                throw new SAXParseException("Length must be at most " + maxLength, this.locator);
            }
        }

        public void checkPattern(Pattern pattern) throws SAXParseException {
            if (pattern.matcher(this.sb.toString()).matches()) {
                return;
            }
            throw new SAXParseException(this.getClass().getName() + ": Unmatched value '" + String.valueOf(this.sb) + "' for " + pattern.pattern(), this.locator);
        }
    }
}

