/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.AnyElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsSignatureContentHandler;
import de.businesslogics.ebics.schema.NamespaceDecl;
import de.businesslogics.ebics.schema.SignedInfoSignatureContentHandler;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.io.NullOutputStream;
import de.businesslogics.util.HexTool;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SignatureContentHandler
extends DefaultHandler {
    private ContentHandler nextHandler = null;
    protected OutputStreamWriter w = null;
    protected MessageDigest digest = null;
    private int elementLevel;
    private int authLevel = -1;
    private final Map<String, LinkedList<String>> prefixMappings = new HashMap<String, LinkedList<String>>();
    private final List<NamespaceDecl> pendingMappings = new ArrayList<NamespaceDecl>();
    private boolean pendingCR;
    private final List<MyAttribute> myAtts = new ArrayList<MyAttribute>();

    protected SignatureContentHandler() {
    }

    public void setNextHandler(ContentHandler ch) {
        this.nextHandler = ch;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.nextHandler != null) {
            this.nextHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.nextHandler != null) {
            this.nextHandler.startDocument();
        }
        this.pendingCR = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.nextHandler != null) {
            this.nextHandler.endDocument();
        }
        try {
            if (this.w != null) {
                this.w.close();
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        String lastURI;
        LinkedList<String> presentMappings;
        if (this.nextHandler != null) {
            this.nextHandler.startPrefixMapping(prefix, uri);
        }
        if ((presentMappings = this.prefixMappings.get(prefix)) == null || presentMappings.isEmpty()) {
            String string = lastURI = prefix.length() == 0 ? "" : null;
            if (presentMappings == null) {
                presentMappings = new LinkedList();
                this.prefixMappings.put(prefix, presentMappings);
            }
        } else {
            lastURI = presentMappings.getLast();
        }
        if (!uri.equals(lastURI) && this.authLevel >= 0) {
            this.pendingMappings.add(new NamespaceDecl(prefix, uri));
        }
        presentMappings.add(uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.nextHandler != null) {
            this.nextHandler.endPrefixMapping(prefix);
        }
        this.prefixMappings.get(prefix).removeLast();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.nextHandler != null) {
            this.nextHandler.startElement(namespaceURI, localName, qName, atts);
        }
        if (this.digest == null) {
            try {
                this.digest = namespaceURI.equals(ProtocolVersion.H002.getNamespace()) ? MessageDigest.getInstance("SHA-1") : MessageDigest.getInstance("SHA-256");
            }
            catch (GeneralSecurityException gse) {
                throw new RuntimeException("Weird security setup", gse);
            }
        }
        if (this.authLevel < 0 && this.startDigest(namespaceURI, localName, qName, atts)) {
            if (this.w == null) {
                try {
                    DigestOutputStream dos = new DigestOutputStream(new NullOutputStream(), this.digest);
                    this.w = new OutputStreamWriter((OutputStream)dos, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Should never happen", e);
                }
            }
            this.authLevel = this.elementLevel;
            for (Map.Entry<String, LinkedList<String>> me : this.prefixMappings.entrySet()) {
                LinkedList<String> mappings = me.getValue();
                if (mappings.isEmpty()) continue;
                String prefix = me.getKey();
                String uri = mappings.getLast();
                if (prefix.length() == 0 && uri.length() == 0) continue;
                this.pendingMappings.add(new NamespaceDecl(prefix, uri));
            }
        }
        ++this.elementLevel;
        if (this.authLevel < 0) {
            return;
        }
        try {
            this.w.write(60);
            this.w.write(qName);
            if (!this.pendingMappings.isEmpty()) {
                Collections.sort(this.pendingMappings);
                for (NamespaceDecl decl : this.pendingMappings) {
                    this.w.write(32);
                    this.w.write("xmlns");
                    if (decl.prefix.length() > 0) {
                        this.w.write(58);
                        this.w.write(decl.prefix);
                    }
                    this.w.write("=\"");
                    this.w.write(decl.uri);
                    this.w.write(34);
                }
                this.pendingMappings.clear();
            }
            if (atts.getLength() > 0) {
                int i;
                this.myAtts.clear();
                for (i = 0; i < atts.getLength(); ++i) {
                    this.myAtts.add(new MyAttribute(atts.getQName(i), atts.getLocalName(i), atts.getURI(i), atts.getValue(i)));
                }
                Collections.sort(this.myAtts);
                for (i = 0; i < this.myAtts.size(); ++i) {
                    MyAttribute myAtt = this.myAtts.get(i);
                    this.w.write(32);
                    this.w.write(myAtt.qName);
                    this.w.write("=\"");
                    this.writeAttribute(myAtt.value);
                    this.w.write(34);
                }
            }
            this.w.write(62);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.nextHandler != null) {
            this.nextHandler.endElement(namespaceURI, localName, qName);
        }
        if (this.authLevel >= 0) {
            try {
                this.w.write("</");
                this.w.write(qName);
                this.w.write(62);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
        --this.elementLevel;
        if (this.elementLevel == this.authLevel) {
            this.authLevel = -1;
            this.endDigest();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.nextHandler != null) {
            this.nextHandler.characters(ch, start, length);
        }
        if (this.authLevel < 0) {
            return;
        }
        try {
            length += start;
            for (int i = start; i < length; ++i) {
                char c = ch[i];
                if (c == '\r') {
                    if (i > start) {
                        this.w.write(ch, start, i - start);
                    }
                    start = i + 1;
                    if (this.pendingCR) {
                        this.w.write(10);
                    }
                    this.pendingCR = true;
                    continue;
                }
                if (c == '\n') {
                    this.pendingCR = false;
                    continue;
                }
                if (this.pendingCR) {
                    this.w.write(10);
                    this.pendingCR = false;
                }
                if (c == '&') {
                    if (i > start) {
                        this.w.write(ch, start, i - start);
                    }
                    this.w.write("&amp;");
                    start = i + 1;
                    continue;
                }
                if (c == '<') {
                    if (i > start) {
                        this.w.write(ch, start, i - start);
                    }
                    this.w.write("&lt;");
                    start = i + 1;
                    continue;
                }
                if (c != '>') continue;
                if (i > start) {
                    this.w.write(ch, start, i - start);
                }
                this.w.write("&gt;");
                start = i + 1;
            }
            if (length > start) {
                this.w.write(ch, start, length - start);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    private void writeAttribute(String s) throws IOException {
        int start = 0;
        int length = s.length();
        for (int i = start; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\r') {
                if (i > start) {
                    this.w.write(s, start, i - start);
                }
                this.w.write("&#xD;");
                start = i + 1;
                continue;
            }
            if (c == '&') {
                if (i > start) {
                    this.w.write(s, start, i - start);
                }
                this.w.write("&amp;");
                start = i + 1;
                continue;
            }
            if (c == '<') {
                if (i > start) {
                    this.w.write(s, start, i - start);
                }
                this.w.write("&lt;");
                start = i + 1;
                continue;
            }
            if (c == '\"') {
                if (i > start) {
                    this.w.write(s, start, i - start);
                }
                this.w.write("&quot;");
                start = i + 1;
                continue;
            }
            if (c == '\n') {
                if (i > start) {
                    this.w.write(s, start, i - start);
                }
                this.w.write("&#xA;");
                start = i + 1;
                continue;
            }
            if (c != '\t') continue;
            if (i > start) {
                this.w.write(s, start, i - start);
            }
            this.w.write("&#x9;");
            start = i + 1;
        }
        if (length > start) {
            this.w.write(s, start, length - start);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        ContentHandler oldNextHandler = this.nextHandler;
        if (this.nextHandler != null) {
            this.nextHandler.ignorableWhitespace(ch, start, length);
            this.nextHandler = null;
        }
        this.characters(ch, start, length);
        this.nextHandler = oldNextHandler;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        throw new SAXException("I am not prepared to be called");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        throw new SAXException("I am not prepared to be called");
    }

    protected abstract boolean startDigest(String var1, String var2, String var3, Attributes var4);

    protected void endDigest() throws SAXException {
    }

    public MessageDigest digest() {
        return this.digest;
    }

    public static void main(String[] args) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        EbicsHandler.VALIDATE = true;
        factory.setValidating(true);
        EbicsHandler handler = new EbicsHandler(AnyElement.PARSER);
        SignatureContentHandler signatureHandler = args.length >= 2 && args[1].equals("signature") ? new SignedInfoSignatureContentHandler() : new EbicsSignatureContentHandler();
        if (args.length >= 3) {
            signatureHandler.w = new FileWriter(args[2]);
        }
        handler.setSignatureHandler(signatureHandler);
        try (FileInputStream fis = new FileInputStream(args[0]);){
            InputSource source = new InputSource(fis);
            parser.parse(source, (DefaultHandler)handler);
        }
        System.err.println("Digest is " + HexTool.toHex(signatureHandler.digest().digest()));
    }

    private static class MyAttribute
    implements Comparable<MyAttribute> {
        final String qName;
        final String localName;
        final String URI;
        final String value;

        private MyAttribute(String qName, String localName, String URI2, String value) {
            this.qName = qName;
            this.localName = localName;
            this.URI = URI2;
            this.value = value;
        }

        @Override
        public int compareTo(MyAttribute c) {
            int i = this.URI.compareTo(c.URI);
            if (i != 0) {
                return i;
            }
            return this.localName.compareTo(c.localName);
        }
    }
}

