/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.util.SystemUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class RootChoiceParser
extends ElementParser {
    private final List<ElementParser> parsers = new ArrayList<ElementParser>();
    private final List<Info> infos = new ArrayList<Info>();
    private ElementParser subParser;

    @Override
    protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
        for (Info info : this.infos) {
            if (info.namespace != null && !info.namespace.equals(uri) || !localName.equals(info.localName) || !this.allowChild(0)) continue;
            try {
                this.subParser = info.clazz.newInstance().createParser();
                return this.subParser;
            }
            catch (Exception e) {
                SystemUtils.throwRuntimeException(e);
            }
        }
        for (ElementParser parser : this.parsers) {
            this.subParser = parser.createChild(uri, localName, qName);
            if (this.subParser == null || !this.allowChild(0)) continue;
            return this.subParser;
        }
        return null;
    }

    @Override
    protected EbicsElement endElement() throws SAXException {
        this.checkLastMandatory(0);
        return this.subParser.endElement();
    }

    public void addParser(ElementParser parser) {
        this.parsers.add(parser);
    }

    public void addPossibleRoot(String namespace, String localName, Class<? extends EbicsElement> clazz) {
        this.infos.add(new Info(namespace, localName, clazz));
    }

    public List<String> getRootNamespaces() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Info i : this.infos) {
            toReturn.add(i.namespace);
        }
        return toReturn;
    }

    public void addPossibleRoot(Class<? extends EbicsElement> clazz) {
        try {
            Field uri = clazz.getDeclaredField("URI");
            Field name = clazz.getDeclaredField("NAME");
            this.infos.add(new Info((String)uri.get(clazz), (String)name.get(clazz), clazz));
        }
        catch (Exception e) {
            SystemUtils.throwRuntimeException(e);
        }
    }

    private static class Info {
        private final String namespace;
        private final String localName;
        Class<? extends EbicsElement> clazz;

        Info(String namespace, String localName, Class<? extends EbicsElement> clazz) {
            this.namespace = namespace;
            this.localName = localName;
            this.clazz = clazz;
        }
    }
}

