/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.NamespaceDecl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;

public class OutputContentHandler
implements ContentHandler {
    private static final int MAX_REPLACEMENT = 160;
    private static final String[] ATTRIBUTE_REPLACEMENTS;
    private static final String[] CONTENT_REPLACEMENTS;
    private final OutputStreamWriter w;
    private final StringBuilder openElement = new StringBuilder();
    private final List<NamespaceDecl> namespaces = new ArrayList<NamespaceDecl>();
    private boolean outputDefaults = true;

    public OutputContentHandler(OutputStream os) throws IOException {
        this.w = new OutputStreamWriter(os, "UTF-8");
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void flush() throws SAXException {
        try {
            this.w.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.w.close();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.add(new NamespaceDecl(prefix, uri));
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.closeTag();
        this.openElement.append('<');
        this.openElement.append(qName);
        if (!this.namespaces.isEmpty()) {
            for (NamespaceDecl decl : this.namespaces) {
                this.openElement.append(' ');
                this.openElement.append("xmlns");
                if (decl.prefix.length() > 0) {
                    this.openElement.append(':');
                    this.openElement.append(decl.prefix);
                }
                this.openElement.append("=\"");
                this.openElement.append(decl.uri);
                this.openElement.append('\"');
            }
            this.namespaces.clear();
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            Attributes2 atts2;
            if (!this.outputDefaults && atts instanceof Attributes2 && !(atts2 = (Attributes2)atts).isSpecified(i)) continue;
            this.openElement.append(' ');
            this.openElement.append(atts.getQName(i));
            this.openElement.append("=\"");
            String value = atts.getValue(i);
            for (int j = 0; j < value.length(); ++j) {
                String s;
                char c = value.charAt(j);
                if (c < ATTRIBUTE_REPLACEMENTS.length && (s = ATTRIBUTE_REPLACEMENTS[c]) != null) {
                    this.openElement.append(s);
                    continue;
                }
                this.openElement.append(c);
            }
            this.openElement.append('\"');
        }
    }

    private void closeTag() throws SAXException {
        if (this.openElement.length() > 0) {
            try {
                this.openElement.append('>');
                this.w.write(this.openElement.toString());
                this.openElement.setLength(0);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (this.openElement.length() > 0) {
                this.openElement.append("/>");
                this.w.write(this.openElement.toString());
                this.openElement.setLength(0);
            } else {
                this.w.write("</");
                this.w.write(qName);
                this.w.write(62);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            int pos;
            this.closeTag();
            int nextChunk = start;
            int end = start + length;
            for (pos = start; pos < end; ++pos) {
                String r;
                char c = ch[pos];
                if (c >= '\u00a0' || (r = CONTENT_REPLACEMENTS[c]) == null) continue;
                if (pos > nextChunk) {
                    this.w.write(ch, nextChunk, pos - nextChunk);
                }
                this.w.write(r);
                nextChunk = pos + 1;
            }
            if (pos > nextChunk) {
                this.w.write(ch, nextChunk, pos - nextChunk);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.w.write(ch, start, length);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        throw new SAXException("I am not prepared to be called");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        throw new SAXException("I am not prepared to be called");
    }

    public boolean isOutputDefaults() {
        return this.outputDefaults;
    }

    public void setOutputDefaults(boolean outputDefaults) {
        this.outputDefaults = outputDefaults;
    }

    static {
        int i;
        ATTRIBUTE_REPLACEMENTS = new String[160];
        CONTENT_REPLACEMENTS = new String[160];
        for (i = 0; i < 32; ++i) {
            if (i == 9 || i == 10 || i == 13) {
                OutputContentHandler.ATTRIBUTE_REPLACEMENTS[i] = "&#x" + Integer.toHexString(i) + ";";
                continue;
            }
            OutputContentHandler.CONTENT_REPLACEMENTS[i] = "";
            OutputContentHandler.ATTRIBUTE_REPLACEMENTS[i] = "";
        }
        for (i = 128; i < 160; ++i) {
            OutputContentHandler.ATTRIBUTE_REPLACEMENTS[i] = i == 133 ? null : "";
            OutputContentHandler.CONTENT_REPLACEMENTS[i] = OutputContentHandler.ATTRIBUTE_REPLACEMENTS[i];
        }
        OutputContentHandler.ATTRIBUTE_REPLACEMENTS[38] = "&amp;";
        OutputContentHandler.CONTENT_REPLACEMENTS[38] = "&amp;";
        OutputContentHandler.ATTRIBUTE_REPLACEMENTS[60] = "&lt;";
        OutputContentHandler.CONTENT_REPLACEMENTS[60] = "&lt;";
        OutputContentHandler.ATTRIBUTE_REPLACEMENTS[62] = "&gt;";
        OutputContentHandler.CONTENT_REPLACEMENTS[62] = "&gt;";
        OutputContentHandler.ATTRIBUTE_REPLACEMENTS[34] = "&quot;";
    }
}

