/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public abstract class ListElement<E extends EbicsElement>
extends EbicsElement
implements List<E> {
    private static final long serialVersionUID = 1L;
    List<E> elements;

    public ListElement() {
        this.elements = new ArrayList();
    }

    public ListElement(List<E> elements) {
        this.elements = elements;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (!this.elements.isEmpty()) {
            Iterator<E> i = this.elements.iterator();
            ((EbicsElement)i.next()).printValue(ps);
            while (i.hasNext()) {
                ps.print(" ");
                ((EbicsElement)i.next()).printValue(ps);
            }
        }
    }

    @Override
    public final ElementParser createParser() {
        return new Parser(this);
    }

    protected abstract E createSubElement();

    @Override
    public void add(int index, E element) {
        this.elements.add(index, element);
    }

    @Override
    public boolean add(E o) {
        return this.elements.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.elements.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.elements.addAll(index, c);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.elements.equals(o);
    }

    @Override
    public E get(int index) {
        return (E)((EbicsElement)this.elements.get(index));
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return (E)((EbicsElement)this.elements.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return (E)((EbicsElement)this.elements.set(index, element));
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    private static class Parser<E extends EbicsElement>
    extends SimpleStringElement.Parser {
        final ListElement<E> element;

        public Parser(ListElement<E> element) {
            this.element = element;
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            StringTokenizer st = new StringTokenizer(this.getCondensed());
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                E sub = this.element.createSubElement();
                this.element.elements.add(sub);
                ElementParser p = ((EbicsElement)sub).createParser();
                p.characters(s.toCharArray(), 0, s.length());
                p.endElement();
            }
            this.element.endElement(this);
            return this.element;
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.element.setAttributes(attributes);
        }
    }
}

