/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IntegerElement
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    protected long value;

    @Deprecated
    public IntegerElement() {
    }

    public IntegerElement(long value) {
        this.value = value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.print(Long.toString(this.value));
    }

    @Override
    public ElementParser createParser() {
        return new Parser(this);
    }

    @Deprecated
    protected void checkMinInclusive(long minInclusive) throws SAXException {
        if (this.value < minInclusive) {
            throw new SAXException(this.value + " less than minimum value " + minInclusive);
        }
    }

    protected void checkMinInclusive(ElementParser parser, long minInclusive) throws SAXParseException {
        if (this.value < minInclusive) {
            throw new SAXParseException(this.value + " less than minimum value " + minInclusive, parser.locator);
        }
    }

    @Deprecated
    protected void checkMaxInclusive(long maxInclusive) throws SAXException {
        if (this.value > maxInclusive) {
            throw new SAXException(this.value + " greater than maximum value " + maxInclusive);
        }
    }

    protected void checkMaxInclusive(ElementParser parser, long maxInclusive) throws SAXParseException {
        if (this.value > maxInclusive) {
            throw new SAXParseException(this.value + " greater than maximum value " + maxInclusive, parser.locator);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntegerElement)) {
            return false;
        }
        return ((IntegerElement)obj).value == this.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    private static class Parser
    extends EbicsElement.Parser {
        private char sign = (char)32;
        private long value = 0L;
        private boolean digits = false;

        public Parser(IntegerElement i) {
            super(i);
        }

        @Override
        protected void characters(char[] ch, int start, int length) throws SAXException {
            length += start;
            for (int i = start; i < length; ++i) {
                char c = ch[i];
                if (Character.isWhitespace(c)) continue;
                if (c == '+' && this.sign == ' ') {
                    this.sign = (char)43;
                    continue;
                }
                if (c == '-' && this.sign == ' ') {
                    this.sign = (char)45;
                    continue;
                }
                if (c >= '0' && c <= '9') {
                    this.value = this.value * 10L + (long)(c - 48);
                    this.digits = true;
                    if (this.sign != ' ') continue;
                    this.sign = (char)43;
                    continue;
                }
                throw new SAXException("Unexpected character " + c);
            }
        }

        protected final long getValue() throws SAXException {
            if (!this.digits) {
                throw new SAXException("No number found");
            }
            return this.value * (long)(this.sign == '+' ? 1 : -1);
        }

        @Override
        public EbicsElement endElement() throws SAXException {
            ((IntegerElement)this.toReturn).value = this.getValue();
            this.toReturn.endElement(this);
            return this.toReturn;
        }
    }
}

