/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.util.HexTool;
import java.io.ByteArrayOutputStream;
import org.xml.sax.SAXException;

public class HexBinaryElement
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    protected byte[] value;

    public HexBinaryElement() {
    }

    public HexBinaryElement(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.print(HexTool.toHex(this.value));
    }

    @Override
    public ElementParser createParser() {
        return new HexBinaryParser(this);
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        this.value = ((HexBinaryParser)parser).getValue();
    }

    protected void checkLength(int l) throws SAXException {
        if (this.value.length != l) {
            throw new SAXException("Illegal length " + this.value.length);
        }
    }

    protected static class HexBinaryParser
    extends Parser {
        final HexBinaryElement element;

        public HexBinaryParser(HexBinaryElement element) {
            this.element = element;
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.element.setAttributes(attributes);
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.element.endElement(this);
            return this.element;
        }
    }

    protected static class Parser
    extends ElementParser {
        private ByteArrayOutputStream bos = new ByteArrayOutputStream();
        private int lastNibble = -1;

        protected Parser() {
            super(0);
        }

        @Override
        protected void characters(char[] content, int offset, int length) throws SAXException {
            length += offset;
            try {
                while (offset < length) {
                    char c;
                    if (Character.isWhitespace(c = content[offset++])) continue;
                    int nibble = HexTool.charValue(c);
                    if (this.lastNibble >= 0) {
                        this.bos.write(this.lastNibble << 4 | nibble);
                        this.lastNibble = -1;
                        continue;
                    }
                    this.lastNibble = nibble;
                }
            }
            catch (IllegalArgumentException iae) {
                throw new SAXException(iae.getMessage());
            }
        }

        protected byte[] getValue() throws SAXException {
            if (this.lastNibble >= 0) {
                throw new SAXException("Odd number of nibbles");
            }
            return this.bos.toByteArray();
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            return new HexBinaryElement(this.getValue());
        }
    }
}

