/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import java.util.regex.Pattern;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ElementParser {
    protected Locator locator;
    protected int currentChild = -1;
    protected final EbicsElement[] children;
    String parentUri;

    protected ElementParser() {
        this.children = null;
    }

    protected ElementParser(int numberOfChildren) {
        this.children = numberOfChildren > 0 ? new EbicsElement[numberOfChildren] : null;
    }

    public int getCurrentChild() {
        return this.currentChild;
    }

    public boolean isParentUri(String uri) {
        return uri.equals(this.parentUri);
    }

    public String getParentUri() {
        return this.parentUri;
    }

    protected String getName() {
        return this.getClass().getName();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    protected void characters(char[] ch, int start, int length) throws SAXException {
        int i = start + length;
        while (--i >= start) {
            if (Character.isWhitespace(ch[i])) continue;
            throw new SAXException("Parser '" + this.getClass().getName() + "' does not accept text content");
        }
    }

    protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
        return null;
    }

    public boolean allowChild(int position) {
        if (this.currentChild != position - 1) {
            return false;
        }
        this.currentChild = position;
        return true;
    }

    public boolean allowOrIsChild(int position) {
        return this.currentChild == position || this.allowChild(position);
    }

    public void checkLastMandatory(int lastMandatoryChild) throws SAXParseException {
        if (this.currentChild >= lastMandatoryChild) {
            return;
        }
        throw new SAXParseException("Mandatory element missing in " + this.getName() + ": (" + this.currentChild + "<" + lastMandatoryChild + ")", this.locator);
    }

    boolean isSubsequenceParser() {
        return false;
    }

    public boolean allowChild(int lastMandatoryPosition, int position) {
        if (this.currentChild < lastMandatoryPosition || this.currentChild >= position) {
            return false;
        }
        this.currentChild = position;
        return true;
    }

    public boolean allowOrIsChild(int lastMandatoryPosition, int position) {
        if (this.currentChild < lastMandatoryPosition || this.currentChild > position) {
            return false;
        }
        this.currentChild = position;
        return true;
    }

    protected void endChild(EbicsElement element) {
        this.children[this.currentChild] = element;
    }

    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
    }

    protected abstract EbicsElement endElement() throws SAXException;

    public void checkPattern(String value, Pattern pattern) throws SAXException {
        if (pattern.matcher(value).matches()) {
            return;
        }
        throw new SAXException(this.getClass().getName() + ": Unmatched value '" + value + "' for " + pattern.pattern());
    }
}

