/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.Attributes2Impl;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.OutputContentHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EbicsPrintStream {
    private static final int INDENT_AMOUNT = 2;
    int indent = 0;
    boolean printlnSeen;
    private State currentElement;
    private final Attributes2Impl attributes = new Attributes2Impl();
    private final ContentHandler contentHandler;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Map<String, String> prefixes = new HashMap<String, String>();
    private final ArrayList<State> stack = new ArrayList(10);
    private boolean writeToBuffer = false;
    private final StringBuilder attributeBuffer = new StringBuilder();
    private char nextPrefix = (char)96;
    private boolean pretty = true;
    private final char[] ONE_CHAR = new char[1];

    public EbicsPrintStream(OutputStream os) throws IOException {
        this(new OutputContentHandler(os));
    }

    public EbicsPrintStream(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public void printStringElement(String element, String value) {
        this.openElement(element);
        this.closeTag();
        this.print(value);
        this.closeElement();
    }

    private void openElement(String uri, String localName, String prefix, String qName) {
        if (this.currentElement != null) {
            this.closeTag();
        }
        if (!this.printlnSeen) {
            this.println();
        }
        this.currentElement = new State(uri, localName, prefix, qName);
        this.stack.add(this.currentElement);
        this.printlnSeen = false;
        this.printIndent();
        this.indent += 2;
    }

    public void openElement(String element) {
        int i = element.indexOf(58);
        if (i > 0) {
            String prefix = element.substring(0, i);
            this.openElement(this.getNamespaceURI(prefix), element.substring(i + 1), prefix, element);
        } else if (this.stack.size() > 0) {
            State lastElement = this.stack.get(this.stack.size() - 1);
            this.openElement(lastElement.uri, element, lastElement.prefix, (String)(lastElement.prefix.length() > 0 ? lastElement.prefix + ":" + element : element));
        } else {
            this.openElement(this.getNamespaceURI(""), element, "", element);
        }
    }

    public void addAttribute(String qName, String value) {
        this.addAttribute(qName, value, true);
    }

    public void addAttribute(String qName, EbicsElement element) {
        if (element == null) {
            return;
        }
        this.writeToBuffer = true;
        element.printValue(this);
        this.writeToBuffer = false;
        this.addAttribute(qName, this.attributeBuffer.toString(), true);
        this.attributeBuffer.setLength(0);
    }

    public void addAttribute(String qName, EbicsElement element, String defaultValue) {
        if (element != null) {
            this.addAttribute(qName, element);
        } else {
            this.addAttribute(qName, defaultValue, false);
        }
    }

    public void addAttribute(String qName, String value, boolean specified) {
        String namespaceURI;
        String localName;
        if (this.currentElement == null) {
            throw new IllegalStateException("Element tag already closed");
        }
        if (value == null) {
            return;
        }
        int i = qName.indexOf(58);
        if (i > 0) {
            localName = qName.substring(i + 1);
            namespaceURI = this.getNamespaceURI(qName.substring(0, i));
        } else {
            namespaceURI = "";
            localName = qName;
        }
        this.attributes.addAttribute(namespaceURI, localName, qName, "CDATA", value);
        if (!specified) {
            this.attributes.setSpecified(this.attributes.getIndex(namespaceURI, localName), false);
        }
    }

    public void closeTag() {
        if (this.currentElement != null) {
            try {
                this.contentHandler.startElement(this.currentElement.uri, this.currentElement.localName, this.currentElement.qName, this.attributes);
                this.attributes.clear();
                this.currentElement = null;
            }
            catch (SAXException se) {
                throw new SAXRuntimeException(se);
            }
        }
    }

    public void closeElement() {
        this.indent -= 2;
        if (this.currentElement == null) {
            if (this.printlnSeen) {
                this.printIndent();
            }
        } else {
            this.closeTag();
        }
        State lastElement = this.stack.remove(this.stack.size() - 1);
        try {
            this.contentHandler.endElement(lastElement.uri, lastElement.localName, lastElement.qName);
        }
        catch (SAXException se) {
            throw new SAXRuntimeException(se);
        }
        if (this.indent > 0) {
            this.println();
        }
    }

    public void printIndent() {
        if (this.pretty) {
            int i = this.indent;
            while (--i >= 0) {
                this.print(' ');
            }
        }
    }

    public void println() {
        if (this.pretty) {
            this.print('\n');
        }
        this.printlnSeen = true;
    }

    public void print(char c) {
        this.ONE_CHAR[0] = c;
        this.print(this.ONE_CHAR);
    }

    public void print(String s) {
        this.print(s.toCharArray());
    }

    public void print(char[] characters) {
        if (this.writeToBuffer) {
            this.attributeBuffer.append(characters);
        } else {
            try {
                this.contentHandler.characters(characters, 0, characters.length);
            }
            catch (SAXException se) {
                throw new SAXRuntimeException(se);
            }
        }
    }

    public void printOutPossibleRoot(EbicsElement rootElement) throws IOException {
        try {
            if (rootElement instanceof EbicsRootElement) {
                this.printOut((EbicsRootElement)rootElement);
            } else {
                String namespace = rootElement.namespace();
                if (namespace == null) {
                    Field uri = rootElement.getClass().getDeclaredField("URI");
                    namespace = (String)uri.get(rootElement.getClass());
                }
                this.contentHandler.startDocument();
                this.addNamespaceDecl("", namespace);
                rootElement.printOut(rootElement.name(), this);
                this.contentHandler.endDocument();
            }
        }
        catch (SAXRuntimeException sre) {
            Throwable t = sre.getCause();
            if (t.getCause() instanceof IOException) {
                throw (IOException)t.getCause();
            }
            IOException toThrow = new IOException("Unexpected SAXException");
            toThrow.initCause(t);
            throw toThrow;
        }
        catch (SAXException se) {
            IOException toThrow = new IOException("Unexpected SAXException");
            toThrow.initCause(se);
            throw toThrow;
        }
        catch (NoSuchFieldException nsf) {
            throw new RuntimeException(nsf);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void printOut(EbicsRootElement rootElement) throws IOException {
        try {
            this.contentHandler.startDocument();
            rootElement.addNamespaceDecls(this);
            rootElement.printOut(rootElement.name(), this);
            this.contentHandler.endDocument();
        }
        catch (SAXRuntimeException sre) {
            Throwable t = sre.getCause();
            if (t.getCause() instanceof IOException) {
                throw (IOException)t.getCause();
            }
            IOException toThrow = new IOException("Unexpected SAXException");
            toThrow.initCause(t);
            throw toThrow;
        }
        catch (SAXException se) {
            Throwable t = se.getCause();
            if (t.getCause() instanceof IOException) {
                throw (IOException)t.getCause();
            }
            IOException toThrow = new IOException("Unexpected SAXException");
            toThrow.initCause(se);
            throw toThrow;
        }
    }

    public void printElement(String uri, String localName, EbicsElement element) {
        if (element == null) {
            return;
        }
        if (uri == null) {
            element.printOut(localName, this);
            return;
        }
        String newPrefix = null;
        Object qName = localName;
        String prefix = this.prefixes.get(uri);
        String oldUri = null;
        if (prefix == null) {
            newPrefix = this.nextPrefix == '`' ? "" : Character.toString(this.nextPrefix);
            this.nextPrefix = (char)(this.nextPrefix + '\u0001');
            prefix = newPrefix;
            try {
                this.contentHandler.startPrefixMapping(prefix, uri);
            }
            catch (SAXException se) {
                throw new SAXRuntimeException(se);
            }
            oldUri = this.namespaces.put(prefix, uri);
            this.prefixes.put(uri, prefix);
        }
        if (prefix.length() != 0) {
            qName = prefix + ":" + localName;
        }
        this.openElement(uri, localName, prefix, (String)qName);
        element.addAttributes(this);
        this.closeTag();
        element.printValue(this);
        this.closeElement();
        if (newPrefix != null) {
            try {
                this.contentHandler.endPrefixMapping(prefix);
            }
            catch (SAXException se) {
                throw new SAXRuntimeException(se);
            }
            if (oldUri != null) {
                this.namespaces.put(newPrefix, oldUri);
            } else {
                this.namespaces.remove(newPrefix);
            }
            this.prefixes.remove(uri);
            this.nextPrefix = (char)(this.nextPrefix - '\u0001');
        }
    }

    public void printElements(String uri, String elementName, List<? extends EbicsElement> elements) {
        if (elementName == null) {
            for (EbicsElement ebicsElement : elements) {
                ebicsElement.printValue(this);
            }
            return;
        }
        for (EbicsElement ebicsElement : elements) {
            ebicsElement.printOut(elementName, this);
        }
    }

    public void printOut(String elementName, EbicsElement element) {
        if (element != null) {
            element.printOut(elementName, this);
        }
    }

    public void printValue(EbicsElement element) {
        if (element != null) {
            element.printValue(this);
        }
    }

    public void printOut(String elementName, List<? extends EbicsElement> ebicsElements) {
        if (ebicsElements == null) {
            return;
        }
        for (EbicsElement ebicsElement : ebicsElements) {
            ebicsElement.printOut(elementName, this);
        }
    }

    public void addNamespaceDecl(String prefix, String uri) {
        try {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
        catch (SAXException se) {
            throw new SAXRuntimeException(se);
        }
        this.namespaces.put(prefix, uri);
        this.prefixes.put(uri, prefix);
    }

    public static byte[] toByteArray(String elementName, EbicsElement element) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            EbicsPrintStream eps = new EbicsPrintStream(bos);
            eps.contentHandler.startDocument();
            element.printOut(elementName, eps);
            eps.contentHandler.endDocument();
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (SAXException se) {
            throw new RuntimeException("Unexpected SAXException", se);
        }
    }

    public static byte[] toByteArray(EbicsElement element) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            EbicsPrintStream eps = new EbicsPrintStream(bos);
            eps.printOutPossibleRoot(element);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String getNamespaceURI(String prefix) {
        String toReturn = this.namespaces.get(prefix);
        if (toReturn == null) {
            if (prefix.length() == 0) {
                return "";
            }
            throw new IllegalArgumentException("Unknown namespace prefix=" + prefix);
        }
        return toReturn;
    }

    private static class State {
        final String qName;
        final String prefix;
        final String uri;
        final String localName;

        public State(String uri, String localName, String prefix, String qName) {
            this.qName = qName;
            this.prefix = prefix;
            this.uri = uri;
            this.localName = localName;
        }
    }

    private static class SAXRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        SAXRuntimeException(Throwable t) {
            super(t);
        }
    }
}

