/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsElementListener;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.util.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EbicsHandler
extends DefaultHandler {
    public static boolean VALIDATE = Boolean.getBoolean("de.businesslogics.ebics.schema.EbicsHandler.validate");
    private static final String CLASSNAME = EbicsHandler.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASSNAME);
    private final LinkedList<ElementParser> stack = new LinkedList();
    private ElementParser currentParser;
    final EbicsAttributes myAttributes = new EbicsAttributes();
    private EbicsElement ebics;
    private final ElementParser rootParser;
    private ContentHandler signatureHandler = null;
    private boolean validate = VALIDATE;
    private EbicsElementListener listener;
    private Locator locator;
    private boolean allowExternalEntities = false;

    public EbicsHandler(ElementParser rootParser) {
        this.rootParser = rootParser;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setSignatureHandler(ContentHandler signatureHandler) {
        this.signatureHandler = signatureHandler;
    }

    public void setListener(EbicsElementListener listener) {
        this.listener = listener;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.myAttributes.setDocumentLocator(locator);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentParser != null) {
            this.currentParser.characters(ch, start, length);
        }
        if (this.signatureHandler != null) {
            this.signatureHandler.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.signatureHandler != null) {
            this.signatureHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        LOGGER.finer(publicId + "," + systemId);
        int i = systemId.lastIndexOf(47);
        InputStream is = null;
        if (i >= 0 && systemId.endsWith(".xsd")) {
            String q;
            char ch;
            Object s = "/de/businesslogics/ebics/schema";
            if (i >= 5 && systemId.charAt(i - 5) == '/' && ((ch = Character.toLowerCase(systemId.charAt(i - 4))) == 'h' || ch == 's') && Character.isDigit(systemId.charAt(i - 3)) && Character.isDigit(systemId.charAt(i - 2)) && Character.isDigit(systemId.charAt(i - 1)) && !"/h002".equals(q = systemId.substring(i - 5, i).toLowerCase())) {
                s = (String)s + q;
            }
            s = (String)s + systemId.substring(i);
            is = this.getClass().getResourceAsStream((String)s);
        }
        if (is == null) {
            if (this.allowExternalEntities) {
                return null;
            }
            throw new SAXParseException("No external entites expected", this.locator);
        }
        InputSource toReturn = new InputSource(is);
        toReturn.setSystemId(systemId);
        toReturn.setPublicId(publicId);
        return toReturn;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack.clear();
        this.currentParser = null;
        if (this.signatureHandler != null) {
            this.signatureHandler.startDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("startPrefixMapping " + (String)(prefix.length() > 0 ? "xmlns:" + prefix : "xmlns") + "=\"" + uri + "\"");
        }
        if (this.signatureHandler != null) {
            this.signatureHandler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("startElement(uri=\"" + uri + "\",localName=\"" + localName + "\",qName=\"" + qName + "\")");
            for (int i = 0; i < attributes.getLength(); ++i) {
                LOGGER.finest("Attribute(qName=" + attributes.getQName(i) + ",localName=" + attributes.getLocalName(i) + ",URI=" + attributes.getURI(i) + ")=(" + attributes.getType(i) + ") " + attributes.getValue(i));
            }
        }
        if (this.currentParser == null) {
            this.currentParser = this.rootParser.createChild(uri, localName, qName);
            if (this.currentParser == null) {
                throw new SAXParseException("Unexpected root element '" + uri + " " + localName + "'", this.locator);
            }
            this.currentParser.parentUri = uri;
            this.currentParser.setLocator(this.locator);
        } else {
            do {
                ElementParser newParser = this.currentParser.createChild(uri, localName, qName);
                while (newParser == null && this.currentParser.isSubsequenceParser()) {
                    EbicsElement element = this.currentParser.endElement();
                    this.currentParser = this.stack.removeLast();
                    this.currentParser.endChild(element);
                    if (this.listener != null) {
                        this.listener.endElement(element);
                    }
                    newParser = this.currentParser.createChild(uri, localName, qName);
                }
                if (newParser == null) {
                    throw new SAXParseException("Unexpected child element '" + qName + "' of parser '" + this.currentParser.getName() + "'", this.locator);
                }
                newParser.setLocator(this.locator);
                newParser.parentUri = uri;
                this.stack.add(this.currentParser);
                this.currentParser = newParser;
            } while (this.currentParser.isSubsequenceParser());
        }
        if (this.listener != null && this.currentParser instanceof EbicsElement.Parser) {
            this.listener.startElement(uri, localName, ((EbicsElement.Parser)this.currentParser).toReturn);
        }
        this.myAttributes.setAttributes(uri, attributes);
        this.currentParser.setAttributes(this.myAttributes);
        String s = this.myAttributes.unusedAttributes();
        if (s != null) {
            throw new SAXParseException(this.currentParser.getName() + " did not evaluate the following attributes: " + s, this.locator);
        }
        if (this.signatureHandler != null) {
            this.signatureHandler.startElement(uri, localName, qName, this.myAttributes.attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        EbicsElement element;
        while (this.currentParser.isSubsequenceParser()) {
            element = this.currentParser.endElement();
            this.currentParser = this.stack.removeLast();
            this.currentParser.endChild(element);
            if (this.listener == null) continue;
            this.listener.endElement(element);
        }
        if (!this.stack.isEmpty()) {
            element = this.currentParser.endElement();
            this.currentParser = this.stack.removeLast();
            this.currentParser.endChild(element);
            if (this.listener != null) {
                this.listener.endElement(element);
            }
        } else {
            this.ebics = this.currentParser.endElement();
            if (this.listener != null) {
                this.listener.endElement(this.ebics);
            }
            this.currentParser = null;
            this.rootParser.endElement();
        }
        if (this.signatureHandler != null) {
            this.signatureHandler.endElement(uri, localName, qName);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.signatureHandler != null) {
            this.signatureHandler.endDocument();
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.signatureHandler != null) {
            this.signatureHandler.endPrefixMapping(prefix);
        }
    }

    public EbicsElement getRoot() {
        return this.ebics;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        LOGGER.fine("SAXParseException at " + e.getSystemId() + ":" + e.getLineNumber() + ":" + e.getColumnNumber() + ": " + String.valueOf(e));
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.error(e);
    }

    @Deprecated
    public EbicsElement parse(InputStream is) throws SAXException, IOException {
        return this.parse(is, null);
    }

    public EbicsElement parse(InputStream is, String namespaceSchemaLocation) throws SAXException, IOException {
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(this.validate && namespaceSchemaLocation != null);
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            LogUtils.logp(LOGGER, Level.FINE, LOGGER.getName(), "parse", "Failed to disallow DOCTYPE declaration!", e);
        }
        try {
            parser = factory.newSAXParser();
            if (factory.isValidating()) {
                XMLReader xmlReader = parser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", true);
                xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                xmlReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", namespaceSchemaLocation);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("No parser available", e);
        }
        InputSource source = new InputSource(is);
        parser.parse(source, (DefaultHandler)this);
        return this.getRoot();
    }

    @Deprecated
    public static EbicsElement parse(InputStream is, ElementParser elementParser) throws SAXException, IOException {
        return EbicsHandler.parse(is, elementParser, null);
    }

    public static EbicsElement parse(InputStream is, ElementParser elementParser, String namespaceSchemaLocation) throws SAXException, IOException {
        EbicsHandler handler = new EbicsHandler(elementParser);
        return handler.parse(is, namespaceSchemaLocation);
    }

    public void setAllowExternalEntities(boolean b) {
        this.allowExternalEntities = b;
    }

    public List<String> getRootNamespaces() {
        if (this.rootParser instanceof RootChoiceParser) {
            return ((RootChoiceParser)this.rootParser).getRootNamespaces();
        }
        return null;
    }
}

