/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.Attributes2Impl;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.ElementParser;
import java.util.BitSet;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EbicsAttributes
implements Attributes {
    private static final String CLASSNAME = EbicsAttributes.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASSNAME);
    public static final String S001_NS = "http://www.ebics.org/S001";
    public static final String S002_NS = "http://www.ebics.org/S002";
    public static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SIGNATURE_NS = "http://www.w3.org/2000/09/xmldsig#";
    private Locator locator;
    public static ThreadLocal<Boolean> BUGGY = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.getBoolean("de.businesslogics.ebics.client.BUGGY");
        }
    };
    Attributes2Impl attributes = new Attributes2Impl();
    BitSet used = new BitSet();
    String parentUri;

    public String getParentUri() {
        return this.parentUri;
    }

    public boolean isParentUri(String uri) {
        return uri.equals(this.parentUri);
    }

    void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    void setAttributes(String parentUri, Attributes attributes) {
        this.used.clear();
        this.parentUri = parentUri;
        this.attributes.setAttributes(attributes);
    }

    String unusedAttributes() {
        int i = this.used.nextClearBit(0);
        StringBuffer toReturn = null;
        while (i < this.attributes.getLength()) {
            if (!SCHEMA_NS.equals(this.attributes.getURI(i))) {
                if (toReturn == null) {
                    toReturn = new StringBuffer(this.attributes.getQName(i));
                } else {
                    toReturn.append(", ");
                    toReturn.append(this.attributes.getQName(i));
                }
            }
            i = this.used.nextClearBit(i + 1);
        }
        return toReturn == null ? null : toReturn.toString();
    }

    @Override
    public int getIndex(String uri, String localName) {
        return this.attributes.getIndex(uri, localName);
    }

    @Override
    public int getIndex(String qName) {
        return this.attributes.getIndex(qName);
    }

    @Override
    public int getLength() {
        return this.attributes.getLength();
    }

    @Override
    public String getLocalName(int index) {
        return this.attributes.getLocalName(index);
    }

    @Override
    public String getQName(int index) {
        return this.attributes.getQName(index);
    }

    @Override
    public String getType(int index) {
        return this.attributes.getType(index);
    }

    @Override
    public String getType(String uri, String localName) {
        return this.attributes.getType(uri, localName);
    }

    @Override
    public String getType(String qName) {
        return this.attributes.getType(qName);
    }

    @Override
    public String getURI(int index) {
        return this.attributes.getURI(index);
    }

    @Override
    public String getValue(int index) {
        if (index < 0) {
            return null;
        }
        this.used.set(index);
        return this.attributes.getValue(index);
    }

    @Override
    public String getValue(String uri, String localName) {
        return this.getValue(this.attributes.getIndex(uri, localName));
    }

    @Override
    public String getValue(String qName) {
        return this.getValue(this.attributes.getIndex(qName));
    }

    public void ignore(String qName) {
        this.getValue(qName);
    }

    public void ignore(String uri, String localName) {
        this.getValue(uri, localName);
    }

    public void ignoreAll() {
        this.used.set(0, this.attributes.getLength());
    }

    public String getValueWithDefault(String qName, String def) {
        String s = this.getValue(qName);
        if (s == null) {
            s = def;
            if (!BUGGY.get().booleanValue()) {
                int i = qName.indexOf(58);
                if (i > 0) {
                    LOGGER.warning("Cannot handle qualified names yet.");
                }
                String namespaceURI = "";
                String localName = qName;
                this.attributes.addAttribute(namespaceURI, localName, qName, "CDATA", s);
                i = this.attributes.getIndex(qName);
                this.attributes.setSpecified(i, false);
                this.used.set(i);
            }
        }
        return s;
    }

    public String getMandatoryValue(String qName) throws SAXParseException {
        String s = this.getValue(qName);
        if (s == null) {
            throw new SAXParseException("Mandatory attribute(qName=" + qName + ") not defined", this.locator);
        }
        return s;
    }

    public <T extends EbicsElement> T setValue(String qName, Class<T> c) throws SAXException {
        String s = this.getValue(qName);
        if (s == null) {
            return null;
        }
        try {
            EbicsElement t = (EbicsElement)c.newInstance();
            ElementParser p = t.createParser();
            p.locator = this.locator;
            char[] v = s.toCharArray();
            p.characters(v, 0, v.length);
            p.endElement();
            return (T)t;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void setValueWithDefault(String qName, EbicsElement element, String def) throws SAXException {
        char[] v = this.getValueWithDefault(qName, def).toCharArray();
        ElementParser parser = element.createParser();
        parser.locator = this.locator;
        parser.characters(v, 0, v.length);
        parser.endElement();
    }

    public void setMandatoryValue(String qName, EbicsElement element) throws SAXException {
        char[] v = this.getMandatoryValue(qName).toCharArray();
        ElementParser parser = element.createParser();
        parser.locator = this.locator;
        parser.characters(v, 0, v.length);
        parser.endElement();
    }

    public boolean getBoolean(String qName) throws SAXParseException {
        String s = this.getMandatoryValue(qName);
        if (s.equals("true") || s.equals("1")) {
            return true;
        }
        if (s.equals("false") || s.equals("0")) {
            return false;
        }
        throw new SAXParseException("Value of attribute(" + qName + ")=" + s + " is not a boolean", this.locator);
    }

    public boolean getBoolean(String qName, boolean fallBack) throws SAXParseException {
        String s = this.getValue(qName);
        if (s == null) {
            this.getValueWithDefault(qName, Boolean.toString(fallBack));
            return fallBack;
        }
        if (s.equals("true") || s.equals("1")) {
            return true;
        }
        if (s.equals("false") || s.equals("0")) {
            return false;
        }
        throw new SAXParseException("Value of attribute(" + qName + ")=" + s + " is not a boolean", this.locator);
    }

    public int getInt(String qName) throws SAXParseException {
        String s = this.getMandatoryValue(qName);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new SAXParseException("Value of attribute(" + qName + ")=" + s + " is not a number", this.locator);
        }
    }

    public int getInt(String qName, int fallBack) throws SAXParseException {
        String s = this.getValue(qName);
        if (s == null) {
            this.getValueWithDefault(qName, Integer.toString(fallBack));
            return fallBack;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new SAXParseException("Value of attribute(" + qName + ")=" + s + " is not a number", this.locator);
        }
    }

    public void checkFixed(String qName, String expected) throws SAXParseException {
        if (!this.getMandatoryValue(qName).equals(expected)) {
            throw new SAXParseException("attribute(qName=" + qName + ") has not the expected value " + expected, this.locator);
        }
    }

    public void checkProhibited(String qName) throws SAXParseException {
        if (this.getValue(qName) != null) {
            throw new SAXParseException("Prohibited attribute(qName=" + qName + ") defined.", this.locator);
        }
    }
}

