/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.math.BigDecimal;
import org.xml.sax.SAXException;

public class DecimalElement
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    public static boolean DISABLE_CHECKS = Boolean.getBoolean("de.businesslogics.ebics.schema.DecimalElement.DISABLE_CHECKS");
    protected BigDecimal value;

    public DecimalElement() {
    }

    public DecimalElement(BigDecimal value) {
        this.value = value;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public static void printOut(BigDecimal value, String elementName, EbicsPrintStream ps) {
        ps.openElement(elementName);
        ps.closeTag();
        ps.print(value.toString());
        ps.closeElement();
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        ps.print(this.value.toString());
    }

    protected void checkMinInclusive(BigDecimal min) throws SAXException {
        if (DISABLE_CHECKS) {
            return;
        }
        if (min.compareTo(this.value) > 0) {
            throw new SAXException(String.valueOf(this.value) + " is less than minimum value " + String.valueOf(min));
        }
    }

    protected void checkMaxInclusive(BigDecimal max) throws SAXException {
        if (DISABLE_CHECKS) {
            return;
        }
        if (max.compareTo(this.value) < 0) {
            throw new SAXException(String.valueOf(this.value) + " is greater than maximum value " + String.valueOf(max));
        }
    }

    @Override
    public ElementParser createParser() {
        return new Parser(this);
    }

    protected static class Parser
    extends SimpleStringElement.Parser {
        private final DecimalElement toReturn;

        private Parser(DecimalElement toReturn) {
            this.toReturn = toReturn;
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.toReturn.setAttributes(attributes);
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            try {
                this.toReturn.value = new BigDecimal(this.getCondensed());
            }
            catch (NumberFormatException nfe) {
                throw new SAXException(nfe);
            }
            this.toReturn.endElement(this);
            return this.toReturn;
        }

        public void checkFractionDigits(int fractionDigits) throws SAXException {
            if (this.toReturn.value.scale() > fractionDigits) {
                try {
                    this.toReturn.value = this.toReturn.value.setScale(fractionDigits, 7);
                }
                catch (ArithmeticException ae) {
                    throw new SAXException(String.valueOf(this.toReturn.value) + " has more than " + fractionDigits + " fraction digits");
                }
            }
        }

        public void checkTotalDigits(int totalDigits) throws SAXException {
            if (this.toReturn.value.precision() > totalDigits) {
                throw new SAXException(String.valueOf(this.toReturn.value) + " has more than " + totalDigits + " total digits.");
            }
        }
    }
}

